<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package vGest
 */

get_header();
?>
<div class="sub-titulos">
	<div class="container">
		<div class="row">
			<div class="col">
				<h1><?php single_post_title(); ?></h1>
			</div>
		</div>
	</div>
</div>

<div class="container">
	<div id="primary" class="row content-area">
		<main id="main" class="col-12 col-md-8 col-lg-9 site-main">

		<?php
		if ( have_posts() ) :


		?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
				vgest_posted_on();
				vgest_posted_by();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->
	
	<div class="row">
		<div class="col-5"><?php vgest_post_thumbnail(); ?>,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,</div>
		<div class="col-7">
			<div class="entry-content">
			<?php
				the_content();
		
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'vgest' ),
					'after'  => '</div>',
				) );
				?>
			</div><!-- .entry-content -->
		</div>
	</div>

	<footer class="entry-footer">
		<?php vgest_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
<?
		endif;
		?>

		</main><!-- #main -->
		<?php get_sidebar(); ?>
	</div><!-- #primary -->
	
<?php
get_footer();