<?php
/**
 * Header template
 **/
global $wplab_albedo_core;
?>
<!doctype html>
<html class="no-js" <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
	<style>	

		.icon-azul span { color: #1877b9 !important; }
		ul li:before { display: none; }
		
		/*--------------------------------------------------------------
		# Header
		--------------------------------------------------------------
		*/
		.interreg { margin: 0 !important; }
		.interreg img { display:inline-block !important;height:80px !important; }
		.logo { display: inline-block !important; margin: 0 0 16px 6px; }
		@media (max-width: 620px) { 
			.interreg img { height:40px !important; }
			.logo { margin: 0 0 7px 6px; width: 113px !important; }
		}
		#header-breadcrumbs .first-item a { border: none !important; padding: 0 !important;  }
		/* Sub-Titulos */
		.sub-titulos { background: #1877b9 url(<?php echo get_template_directory_uri() ?>/img/logo-fundo.png); background-repeat: no-repeat; background-position: right 30%; padding-top: 3rem; padding-bottom: 4rem; margin-bottom: 4rem;}
		.sub-titulos h1 { margin-bottom: 0; }
		
		
		/*--------------------------------------------------------------
		# Footer
		--------------------------------------------------------------*/
		.widget.widget_nav_menu { margin-bottom: 0 !important; }	
		#menu-footer-2 { text-align: right; }
		#menu-footer-2 a { color: #fff !important;}
		#menu-footer-2 a:hover { text-decoration: underline; }
		#footer-widgets .col-md-12 { position: relative; }
		#custom_html-3 .logo-interreg { position: absolute; bottom: 0; left: 0; }

		.site-footer-nav { margin: 0; padding: 0; }
		.site-footer-nav li { display: inline-block; }
		.site-footer-nav a { text-align: left;  color: rgba(255, 255, 255,.6) !important; font-weight: 400; }
		.site-footer-nav a:hover { color: rgba(255, 255, 255,1) !important; }
		.bottom-bar-content { border-top: 1px solid rgba(255,255,255,1) !important; }
		.site-footer-nav li:before { content:"" !important; }
		.site-footer-nav li:first-child { padding-left: 0; }

		
		/*--------------------------------------------------------------
		# HomePage
		--------------------------------------------------------------*/		
		.class-news { padding: 2.4rem 1rem 1rem 1rem !important;  }
		.class-news .post-likes { display: none; }
		.class-news h3 { margin-bottom: 1.5rem !important; }
		.class-news .shortcode-blog-2cols article {  padding-bottom: 20px !important; margin-bottom: 30px !important; }
		.class-news .class-not-home { color: #1877b9; }
		.class-news .class-not-home:hover { color: #1877b9; }
				
		.class-intro { padding: 2.5rem 2.5rem 3rem 2.5rem !important;  }
		.class-intro, .class-intro h2 { color: #fff; }
		@media (max-width: 768px) { .class-intro .vc_column-inner { padding-left: 15px !important; } }
		.p-class-not-home { padding-left: 0 !important; }
		.p-class-not-home a,
			.class-not-home { font-size: 0.8em; color: rgba(255, 255, 255,.5); font-weight: 700; text-decoration: none; padding-left: 0%; }
		.p-class-not-home a:hover,
			.class-not-home:hover { color: rgba(255, 255, 255,1); }

		.class-not-home { padding: 0 0 0 2rem; }

		.home-topico a { display: block; text-align: center; text-transform: uppercase; color: #757575; font-size: .55em; font-weight: 700; text-decoration: none; }
		.home-topico a:hover { color: #000; text-decoration: none; }
		.home-topico a img { width: 100%; }
		.home-topico-container { padding: 0 6%; }
		.home-topico-container .home-topico-coluna { width: 10% !important; }
		.home-topico-container img { padding: 0 2em; }
		
		.logos-slider { height:400px; overflow: hidden; }
		.logos-slider .vc_column-inner,
			.logos-slider .wpb_content_element,
			.logos-slider .vc_col-sm-12 { padding: 0 !important; margin: 0 !important; }
		.logos-slider .theme-default .nivoSlider { box-shadow:none; }
		.logos-slider .nivo-controlNav, .logos-slider .nivo-directionNav, .logos-slider .nivo-caption { display: none; }
		.logos-slider-container { background:#1877b9; position: absolute; left: 50%; top: 12%; z-index: 10; margin-left: -30%; width: 60%; color: #fff; padding: 2em; }
		.logos-slider-container h2  { color: #fff; }
		.logos-slider-container p { margin-bottom: 0; }
		
		/* Foto do grupo, topo do ecrã */
		.home-photo { height: 200px; }
		@media (min-width: 768px) { .home-photo { height: 300px; } }
		@media (min-width: 1200px) { .home-photo { height: 400px; } }
		
		/*--------------------------------------------------------------
		# Project
		--------------------------------------------------------------*/
		.vc_tta-tabs-container { border-left: 1px solid #1877b9; }
		.tab-quemsomos .vc_tta-container { margin-bottom: 0 !important; }
		.tab-quemsomos .vc_tta-panel-body { padding-bottom: 5rem !important; }
		.tab-quemsomos .vc_tta-tab.vc_active>a { background-color: #1877b9 !important; color: #fff !important; }

		/*--------------------------------------------------------------
		# Contactos
		--------------------------------------------------------------*/
		.form-check-input span.wpcf7-list-item { margin: 0; }
		.form-group { margin-bottom: 1rem; }
		.fs-checkbox-marker { margin: 0 10px -2px 0 !important; }
		
		.newsletter-box { background:#666 url(http://www.ifado.eu/wp-content/uploads/2018/08/newsletter-bg.jpg) no-repeat right center; background-size:   48%; }
		.newsletter-box { padding: 20px; margin-right: 30px; color: #fff; }
		.newsletter-box h2 { color: #fff; margin-bottom: 13px; }
		.newsletter-box p { margin-bottom: 25px; }
		
		/*--------------------------------------------------------------
		# Sidebar
		--------------------------------------------------------------*/
		.aside.widgets-style-boxed #sidebar,
			.aside.widgets-style-boxed #search-2,
			.aside.widgets-style-boxed #categories-2,
			.aside.widgets-style-boxed #recent-posts-2,
			.aside.widgets-style-boxed #archives-2 { background: #1877b9 !important; padding: 30px !important; }
		
		/* Widgtet Newsletter */
		.aside.widgets-style-boxed #text-3 { padding: 0 !important; }
		.aside.widgets-style-boxed #text-3 .newsletter-box { margin-right: 0 !important; }
		
		.aside.widgets-style-boxed .widget-title { color: #fff !important; border-bottom: 1px solid rgba(255,255,255,1) !important; padding-bottom: 12px !important; }
		.widget.widget_archive a, .widget.widget_categories a, .widget.widget_meta a, .widget.widget_pages a, .widget.widget_recent_comments a, .widget.widget_recent_entries a, .widget.widget_rss a, .widget.widget-wedocs a { color:rgba(255, 255, 255,.6) !important; }
		.widget.widget_archive a:hover, .widget.widget_categories a:hover, .widget.widget_meta a:hover, .widget.widget_pages a:hover, .widget.widget_recent_comments a:hover, .widget.widget_recent_entries a:hover, .widget.widget_rss a:hover, .widget.widget-wedocs a:hover { color:rgba(255, 255, 255,1) !important; }
		.widget_recent_entries .post-date, .widget_rss .rss-date { color:rgba(255, 255, 255,.3) !important; }
		.widget ul li, .widget ol li { padding-left: 0 !important; }
		.blog #header, .archive #header, .single-post #header { margin-bottom: 40px; }
		
		/*--------------------------------------------------------------
		# Notícias
		--------------------------------------------------------------*/
		.single-blog-post-container.style-default .content-featured-image-wrapper img, .single-blog-post-container.style-default #wplab-albedo-single-post-link { border-radius: 0 !important; }
		.content-featured-image-wrapper { margin: 0 0 30px 0; }
		.shortcode-blog article { }
		.shortcode-blog article { box-shadow: none !important; border-radius: 0 !important; border-bottom: 1px solid rgba(0,0,0,0.2) !important; }
		.shortcode-blog article .post-media img, .shortcode-blog article .post-media iframe, .shortcode-blog article .post-media .overlay { border-radius: 0 !important; }
		.shortcode-blog .post-media { background-color: rgba(0,0,0,0.2);  }
		.shortcode-blog h2 a:hover { color: #0078ce !important; }
		
		/*--------------------------------------------------------------
		# Collaboration
		--------------------------------------------------------------*/
		.aside-menus h3 { font-size: 28px !important; color: #1877b9; margin-bottom: 10px; }
		.aside-menus .p-class-not-home a { font-size: 0.8em; color: rgba(24, 121, 189,.7); font-weight: 700; text-decoration: none; padding-left: 0%; }
		.aside-menus .p-class-not-home a:hover { color: rgba(24, 121, 189,1); }
		
		.formulario legend { font-weight: 700; color: #000; margin-bottom: 1em; }
		.formulario .container .col-12 { width: 98.7%; } 
		.formulario .container .col-6 { width: 49%; display: inline-block; } 
		.formulario .container .col-8 { width: 69%; display: inline-block; } 
		.formulario .container .col-4 { width: 29%; display: inline-block; }  
				
		/*--------------------------------------------------------------
		# Resources
		--------------------------------------------------------------*/
		.shortcode-numeric-benefits .number { font-size: 80px !important; }
		.shortcode-numeric-benefits .item-inside { margin-bottom: 19px !important; }
		
		/*--------------------------------------------------------------
		# Consortium
		--------------------------------------------------------------*/
		.lista-parceiros .lshowcase-boxInner > a { float: left; }
		.lista-parceiros  a { text-decoration: none; }
		.lista-parceiros .lshowcase-description { max-width: none !important; float: left; text-align: left; border-left: 1px solid rgba(0,0,0,0.2) !important; padding-left: 1em !important; width: 80%; }
		.lista-parceiros .lshowcase-box-1 {     border-bottom: 1px solid rgba(0,0,0,0.2) !important;     margin-bottom: 40px; padding-bottom: 18px; }
		
		/*--------------------------------------------------------------
		# Formulario
		--------------------------------------------------------------*/
		.formulario { margin-bottom: 18px !important; }
		.formulario .container { padding-bottom: 5px ; }
		
		.wpcf7-form .acceptance label { display: none !important; }
		.acceptance span.wpcf7-list-item { margin: 0 !important; }

	</style>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<?php
	/**
	 * Display page preloader
	 * this function located at /wproto/helper/front.php
	 **/
	wplab_albedo_front::preloader();

	$header_css_classes = $header_attributes = array();
	$is_slider_mode = false;

	/**
	 * Base header CSS classes
	 **/

	// Get CSS class of header layout
	$header_layout = wplab_albedo_utils::get_theme_mod(
		'header_layout',
		$wplab_albedo_core->default_options['header_layout']
	);

	$header_css_classes[] = 'header-layout-' . esc_attr( $header_layout );

	// Is slider mode enabled?
	if( wplab_albedo_utils::is_unyson() && ((is_page() && filter_var( fw_get_db_post_option( get_the_ID(), 'slider_header_mode' ), FILTER_VALIDATE_BOOLEAN )) || ( is_404() && filter_var( fw_get_db_customizer_option( 'page_404_slider_header_mode' ), FILTER_VALIDATE_BOOLEAN ) )) ) {
		$header_css_classes[] = 'slider-mode';
		$is_slider_mode = true;
	}

	/**
	 * Header effects
	 **/
	$header_parallax = $header_media_effect = array();
	$video_parallax = $particles = $particlegroud = false;

	if( wplab_albedo_utils::is_unyson() && ! $is_slider_mode ) {

		$header_parallax = fw_get_db_customizer_option( 'header_parallax_effect', $wplab_albedo_core->default_options['header_parallax_effect']);

		/**
		 * Standard parallax
		 **/
		if( $header_parallax['effect'] == 'parallax' ) {
			$parallax_speed = fw_get_db_customizer_option( 'header_parallax_effect/parallax/parallax_speed', $wplab_albedo_core->default_options['header_parallax_effect_parallax_speed']);
			$header_css_classes[] = 'parallax-section';
			$header_attributes[] = 'data-stellar-background-ratio="' . esc_attr( $parallax_speed ) . '"';
		}

		/**
		 * Mouse parallax
		 **/
		elseif( $header_parallax['effect'] == 'mouse_parallax' ) {
			$header_css_classes[] = 'parallax-js-section';
			$header_css_classes[] = 'no-bg-image';
		}

		// Media effects

		$header_media_effect = fw_get_db_customizer_option( 'header_media_effect', $wplab_albedo_core->default_options['header_media_effect']);

		/**
		 * Video background
		 **/
		if( $header_media_effect['effect'] == 'video' ) {
			$header_css_classes[] = 'video-bg-section';
			$_video_parallax_speed = fw_get_db_customizer_option( 'header_media_effect/video/video_parallax_speed', $wplab_albedo_core->default_options['header_videobg_parallax_speed']);

			if( $_video_parallax_speed <> '' ) {
				$header_css_classes[] = 'video-parallax';
				$video_parallax = true;
			}
		}

		/**
		 * Particle Groud Effect
		 **/
		elseif( $header_media_effect['effect'] == 'particleground' ) {
			$particlegroud = true;
			if( is_page() && wplab_albedo_utils::is_unyson() && filter_var( fw_get_db_post_option( get_the_ID(), 'hide_header_title' ), FILTER_VALIDATE_BOOLEAN ) ) {
				$particlegroud = false;
			}
		}

		/**
		 * Particles Effect
		 **/
		elseif( $header_media_effect['effect'] == 'particles' ) {
			wplab_albedo_front::generate_header_particles_script();
			$particles = true;
		}

	}

?>

	<!--
		Main wrapper
	-->
	<div id="wrap">

		<div id="header" <?php echo implode( ' ', $header_attributes ); ?> class="<?php echo implode( ' ', $header_css_classes ); ?>">

			<?php if( wplab_albedo_utils::is_unyson() && ! $is_slider_mode && isset( $header_parallax['effect'] ) && $header_parallax['effect'] == 'mouse_parallax' ): ?>
			<!--
				Mouse Parallax Scene
			-->
			<?php
				$mouse_parallax_img_src = fw_get_db_customizer_option( 'header_bg_image_src');
				$mouse_parallax_img = isset( $mouse_parallax_img_src['data']['icon'] ) && $mouse_parallax_img_src['data']['icon'] <> '' ? $mouse_parallax_img_src['data']['icon'] : '';
				if( is_page() || is_singular() || is_single() ) {
					$custom_page_header_bg = fw_get_db_post_option( get_the_ID(), 'page_header_bg' );
					if( isset( $custom_page_header_bg['url'] ) && $custom_page_header_bg['url']  <> '' ) {
						$mouse_parallax_img = $custom_page_header_bg['url'];
					}
				} elseif( is_home() ) {
					$custom_page_header_bg = fw_get_db_post_option( get_option('page_for_posts'), 'page_header_bg' );
					if( isset( $custom_page_header_bg['url'] ) && $custom_page_header_bg['url']  <> '' ) {
						$mouse_parallax_img = $custom_page_header_bg['url'];
					}
				} elseif( function_exists('is_woocommerce') && is_woocommerce() ) {
					$custom_page_header_bg = fw_get_db_post_option( get_option('woocommerce_shop_page_id'), 'page_header_bg' );
					if( isset( $custom_page_header_bg['url'] ) && $custom_page_header_bg['url']  <> '' ) {
						$mouse_parallax_img = $custom_page_header_bg['url'];
					}
				}
				if( $mouse_parallax_img <> '' ):
			?>
			<div class="header-mouseparallax-wrapper">
				<ul class="parallax-scene"
						data-invert-x="<?php echo filter_var( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/invert_x', $wplab_albedo_core->default_options['header_mouse_parallax_invert_x']), FILTER_VALIDATE_BOOLEAN) ? 'true' : 'false'; ?>"
						data-invert-y="<?php echo filter_var( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/invert_y', $wplab_albedo_core->default_options['header_mouse_parallax_invert_y']), FILTER_VALIDATE_BOOLEAN) ? 'true' : 'false'; ?>"
						data-limit-x="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/limit_x', $wplab_albedo_core->default_options['header_mouse_parallax_limit_x']) ); ?>"
						data-limit-y="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/limit_y', $wplab_albedo_core->default_options['header_mouse_parallax_limit_y']) ); ?>"
						data-scalar-x="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/scalar_x', $wplab_albedo_core->default_options['header_mouse_parallax_scalar_x']) ); ?>"
						data-scalar-y="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/scalar_y', $wplab_albedo_core->default_options['header_mouse_parallax_scalar_y']) ); ?>"
						data-friction-x="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/friction_x', $wplab_albedo_core->default_options['header_mouse_parallax_friction_x']) ); ?>"
						data-friction-y="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/friction_y', $wplab_albedo_core->default_options['header_mouse_parallax_friction_y']) ); ?>"
						data-origin-x="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/origin_x', $wplab_albedo_core->default_options['header_mouse_parallax_origin_x']) ); ?>"
						data-origin-y="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/origin_y', $wplab_albedo_core->default_options['header_mouse_parallax_origin_y']) ); ?>">
					<li style="background-image: url(<?php echo esc_attr( $mouse_parallax_img ); ?>);" class="layer layer-bg" data-depth="<?php echo esc_attr( fw_get_db_customizer_option( 'header_parallax_effect/mouse_parallax/depth', $wplab_albedo_core->default_options['header_mouse_parallax_depth']) ); ?>"><div></div></li>
				</ul>
			</div>
			<?php endif; endif; ?>

			<?php if( wplab_albedo_utils::is_unyson() && ! $is_slider_mode && isset( $header_media_effect['effect'] ) && $header_media_effect['effect'] == 'video' ): ?>
			<!--
				Header Video BG Effect markup
			-->
			<?php
				$_video_params = array(
					'videoURL' => esc_attr( fw_get_db_customizer_option( 'header_media_effect/video/video', $wplab_albedo_core->default_options['header_videobg_url']) ),
					'containment' => '#header-video',
					'autoPlay' => 'true',
					'mute' => esc_attr( fw_get_db_customizer_option( 'header_media_effect/video/video_mute', $wplab_albedo_core->default_options['header_videobg_video_mute']) ),
					'showControls' => 'false',
					'quality' => 'hd720',
					'loop' => 'true',
					'showYTLogo' => 'false'
				);

				$video_fallback_url = fw_get_db_customizer_option( 'header_media_effect/video/video_fallback_image');
				if( isset( $video_fallback_url['url'] ) ) {
					$_video_params['mobileFallbackImage'] = $video_fallback_url['url'];
				}

			?>
			<div class="video-bg" id="header-video" data-property='<?php echo json_encode( $_video_params ); ?>' <?php if( $video_parallax ): ?>data-stellar-ratio="<?php echo esc_attr( fw_get_db_customizer_option( 'header_media_effect/video/video_parallax_speed', $wplab_albedo_core->default_options['header_videobg_parallax_speed']) ); ?>"<?php endif; ?> style="position: absolute; top: 0; right: 0; bottom: 0; left: 0;"></div>
			<?php endif; ?>

			<?php if( $particles && ! $is_slider_mode ): ?>
			<!--
				Particles Header Effect markup
			-->
			<div class="particles-section">
				<div class="particles-element" id="particles-main-header"></div>
			</div>
			<?php endif; ?>

			<?php if( $particlegroud && !$is_slider_mode ): ?>

			<?php
				$_particles_attributes[] = 'data-dot-color="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/dot_color' ) ) . '"';
				$_particles_attributes[] = 'data-line-color="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/line_color' ) ) . '"';
				$_particles_attributes[] = 'data-particle-radius="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/particle_radius' ) ) . '"';
				$_particles_attributes[] = 'data-line-width="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/line_width' ) ) . '"';
				$_particles_attributes[] = 'data-curved-lines="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/curved_lines' ) ) . '"';
				$_particles_attributes[] = 'data-parallax="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/parallax' ) ) . '"';
				$_particles_attributes[] = 'data-parallax-multiplier="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/parallax_multiplier' ) ) . '"';
				$_particles_attributes[] = 'data-proximity="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/proximity' ) ) . '"';
				$_particles_attributes[] = 'data-min-speed-x="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/min_speed_x' ) ) . '"';
				$_particles_attributes[] = 'data-max-speed-x="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/max_speed_x' ) ) . '"';
				$_particles_attributes[] = 'data-min-speed-y="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/min_speed_x' ) ) . '"';
				$_particles_attributes[] = 'data-max-speed-y="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/max_speed_x' ) ) . '"';
				$_particles_attributes[] = 'data-direction-x="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/direction_x' ) ) . '"';
				$_particles_attributes[] = 'data-direction-y="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/direction_y' ) ) . '"';
				$_particles_attributes[] = 'data-destiny="' . esc_attr( fw_get_db_customizer_option( 'header_media_effect/particleground/destiny' ) ) . '"';
			?>
			<div id="header-particlegroud" class="particle-ground-section" <?php echo implode(' ', $_particles_attributes ); ?>></div>

			<?php endif; ?>

			<!--
				Particles Header Effect markup
			-->
			<div id="header-bg-overlay"></div>

			<!--
				Top Bar
			-->
			<?php get_template_part('template-parts/header/top-bar'); ?>

			<!--
				Menu
			-->
			<?php get_template_part('template-parts/header/menu'); ?>

			<!--
				Sub-header
			-->
			<?php get_template_part('template-parts/header/subheader'); ?>
		</div>
