<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $el_id
 * @var $css_animation
 * @var $css
 * @var $content - shortcode content
 * @var $dropcap - is dropcap
 * @var $dropcap_style - dropcap style
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Column_text
 */
$el_class = $el_id = $css = $css_animation = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$class_to_filter = 'wpb_text_column wpb_content_element ' . $this->getCSSAnimation( $css_animation );
$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts );

$dropcap = filter_var( $dropcap, FILTER_VALIDATE_BOOLEAN );

$wrapper_attributes = array();

if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
echo '<div class="' . esc_attr( $css_class ) . '" ' . implode( ' ', $wrapper_attributes ) . '><div class="wpb_wrapper">';

if( $dropcap ) {
	echo '<div class="dropcap style-' . esc_attr( $dropcap_style ) . '">';
}

echo wpb_js_remove_wpautop( $content, true );

if( $dropcap ) {
	echo '</div>';
}

echo '</div></div>';
