<?php
  global $wplab_albedo_core;
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
	$attributes = $classes = array();

	/** unique id **/
	$attributes[] = 'id="shortcode-' . esc_attr( $atts['el_id'] ) . '"';
	$attributes[] = 'data-min-distance="' . absint( $atts['min_distance'] ) . '"';

  $terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'timeline_events',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'timeline_events_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );
?>
<div <?php echo implode( ' ', $attributes ); ?> class="horizontal-timeline <?php echo implode( ' ', $classes ); ?>">

	<div class="timeline">
		<div class="events-wrapper">
			<div class="events">
				<ol>
          <?php
            $i=0; while ( $items->have_posts() ): $items->the_post(); $i++;
            $date = get_the_date( 'd/m/Y', get_the_ID());
          ?>
          <li><a href="javascript:;" data-date="<?php echo $date; ?>" <?php if( $i == 1 ): ?>class="selected"<?php endif; ?>><?php echo $date; ?></a></li>
          <?php endwhile; wp_reset_postdata(); ?>
				</ol>

				<span class="filling-line" aria-hidden="true"></span>
			</div>
		</div>

		<div class="timeline-navigation">
			<a href="javascript:;" class="prev inactive"></a>
			<a href="javascript:;" class="next"></a>
		</div>
	</div>

	<div class="events-content">
		<ol>
      <?php
        $i=0; while ( $items->have_posts() ): $items->the_post(); $i++;
        $date = get_the_date( 'd/m/Y', get_the_ID());
      ?>
      <li <?php if( $i == 1 ): ?>class="selected"<?php endif; ?> data-date="<?php echo $date; ?>">
        <div class="item-content">
          <?php the_content(); ?>
        </div>
      </li>
      <?php endwhile; wp_reset_postdata(); ?>
		</ol>
	</div>

</div>
