<?php

  if( absint( $atts['table_id'] ) === 0 ) {
    return false;
  }

  $table_data = get_post_meta( $atts['table_id'], 'pricing_table', true );
  $table_style = get_post_meta( $atts['table_id'], 'table_style', true );

  if( !isset( $table_data['packages']['names'] ) || empty( $table_data['packages']['names'] ) ) {
    return;
  }

  /**
   * Simple table style
  **/
  if( strpos( $table_style, 'fw-table') !== false ):
    $featured_col = isset( $table_data['pricing_table']['featured'] ) ? absint( $table_data['pricing_table']['featured'] ) : -1;
    $desc_col = isset( $table_data['pricing_table']['desc_col'] ) ? absint( $table_data['pricing_table']['desc_col'] ) : -1;
?>
<div class="<?php echo $table_style; ?>">
  <table>
    <?php if( isset( $table_data['packages']['names'] ) && ! empty( $table_data['packages']['names'] ) ): ?>
      <thead>
        <tr class="heading-row">
        <?php foreach( $table_data['packages']['names'] as $title ): ?>
          <th class="default-col"><?php echo $title; ?></th>
        <?php endforeach; ?>
        </tr>
      </thead>
    <?php endif; ?>

    <?php if( isset( $table_data['features']['user_features_values'] ) && ! empty( $table_data['features']['user_features_values'] ) ): ?>
      <tbody>

        <?php $i=0; foreach( $table_data['features']['user_features_values'][0] as $k => $v ): ?>
          <tr class="default-row">

            <?php for( $j=0; $j<count( $table_data['packages']['names'] ); $j++ ): ?>
              <td class="<?php echo $featured_col == $j || $desc_col == $j ? 'desc-col' : 'default-col'; ?>"><?php echo $table_data['features']['user_features_values'][$j][$i]; ?></td>
            <?php endfor; ?>

          </tr>
        <?php $i++; endforeach; ?>

      </tbody>
    <?php endif; ?>

  </table>
</div>
<?php
  /**
   * Pricing Tables Styles
  **/
  else:
?>
<div class="<?php echo $table_style; ?>">

<?php
  $featured_col = isset( $table_data['pricing_table']['featured'] ) ? absint( $table_data['pricing_table']['featured'] ) : -1;
  $desc_col = isset( $table_data['pricing_table']['desc_col'] ) ? absint( $table_data['pricing_table']['desc_col'] ) : -1;
  $cols = 12/count( $table_data['packages']['names'] );
  $style = str_replace( '-', '_', trim( str_replace( 'fw-pricing', '', $table_style ) ) );

  foreach( $table_data['packages']['names'] as $package_id => $package_name ):
?>
  <div class="fw-package-wrap col-md-<?php echo $cols; ?> <?php if( $package_id == $featured_col ): ?>highlight-col<?php elseif( $package_id == $desc_col ): ?>desc-col<?php else: ?>default-col<?php endif; ?>">
    <div class="fw-package">

      <?php include( 'pricing_tables/' . $style . '.php' ); ?>

    </div>
  </div>
<?php endforeach; ?>
</div>
<?php endif;
