<?php
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
  $choices = explode( "\n", $atts['choices'] );
?>
<div class="form-builder-item">
  <div class="field-checkbox input-styled">

    <?php if( $atts['label'] <> '' ): ?>
      <label><?php echo wp_kses_post( $atts['label'] ); ?></label>
    <?php endif; ?>

    <input type="hidden" name="field_<?php echo esc_attr( $atts['el_id'] ); ?>_f_label" value="<?php echo esc_attr( $atts['label'] ); ?>" />

    <div class="custom-checkbox">

      <?php if( is_array( $choices ) && count( $choices ) > 0 ): $i=0; foreach( $choices as $choice ): $choice = strip_tags( $choice ); $i++; ?>
        <label><input value="<?php echo esc_attr( $choice ); ?>" <?php if( $i == 1 ): ?>checked="checked"<?php endif; ?> type="radio" name="field_<?php echo esc_attr( $atts['el_id'] ); ?>" /> <?php echo wp_kses_post( $choice ); ?></label>
      <?php endforeach; endif; ?>

    </div>

    <?php if( $atts['description'] <> '' ): ?>
    <p class="instructions">
      <em><?php echo wp_kses_post( $atts['description'] ); ?></em>
    </p>
    <?php endif; ?>

  </div>
</div>
