<?php

  /**
    * Horizontal Timeline Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Timeline_H extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        /** load static stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-timeline-h', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/timeline_h.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/timeline_h_variable.less') );
        wp_enqueue_style( 'wplab-albedo-timeline-h-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'modernizr' );
    		wp_enqueue_script( 'jquery-mobile' );
    		wp_enqueue_script( 'wplab-albedo-timeline-h', wplab_albedo_utils::locate_uri('/js/libs/h-timeline.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_timeline_h.php';
        return ob_get_clean();

      }

    }
  }
