<?php

vc_map( array(
  'name' => esc_html__( 'Testimonials Modern', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_testimonials_modern',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/testimonials-modern.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/testimonials-modern/js/vc.js',
	'category' => esc_html__( 'Testimonials', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add testimonials modern', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All Testimonials', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Testimonials only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Testimonials except categories', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slides count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '10',
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'admin_label' => true,
      'value' => '',
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),

    /**
     * General tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Element style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'value' => array(
        esc_html__('White', 'wplab-albedo-core-plugin') => 'white',
        esc_html__('White, with rounded corners', 'wplab-albedo-core-plugin') => 'white corners',
        esc_html__('Blue', 'wplab-albedo-core-plugin') => 'blue',
        esc_html__('Blue, with rounded corners', 'wplab-albedo-core-plugin') => 'blue corners',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Background layers position', 'wplab-albedo-core-plugin'),
      'param_name' => 'bg_layers_position',
      'save_always' => true,
      'value' => array(
        esc_html__('Top', 'wplab-albedo-core-plugin') => 'top',
        esc_html__('Bottom', 'wplab-albedo-core-plugin') => 'bottom',
        esc_html__('Do not display', 'wplab-albedo-core-plugin') => 'hidden',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Custom font family', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_font_family',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
			'type' => 'google_fonts',
			'param_name' => 'google_fonts',
			'value' => '',
      'dependency' => array(
  			'element' => 'custom_font_family',
  			'not_empty' => true,
  		),
			'settings' => array(
				'fields' => array(
					'font_family_description' => __( 'Select font family.', 'wplab-albedo-core-plugin' ),
					'font_style_description' => __( 'Select font styling.', 'wplab-albedo-core-plugin' ),
				),
			),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
		),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Carousel settings tab
    **/

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Carousel Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'save_always' => true,
      'value' => array(
        esc_html__('Slide', 'wplab-albedo-core-plugin') => 'slide',
        esc_html__('Fade', 'wplab-albedo-core-plugin') => 'fade',
        esc_html__('Cube', 'wplab-albedo-core-plugin') => 'cube',
        esc_html__('Coverflow', 'wplab-albedo-core-plugin') => 'coverflow',
        esc_html__('Flip', 'wplab-albedo-core-plugin') => 'flip',
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Pagination', 'wplab-albedo-core-plugin' ),
      'param_name' => 'pagination',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Pagination arrows', 'wplab-albedo-core-plugin' ),
      'param_name' => 'pagination_arrows',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display an author name from previous review', 'wplab-albedo-core-plugin' ),
      'param_name' => 'p_arrows_display_prev_name',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
      'dependency' => array(
  			'element' => 'pagination_arrows',
  			'not_empty' => true,
  		),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Previous link title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'p_arrows_prev_title',
      'save_always' => true,
      'value' => esc_html__( 'Previous Review', 'wplab-albedo-core-plugin' ),
      'dependency' => array(
        'element' => 'p_arrows_display_prev_name',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display an author name from next review', 'wplab-albedo-core-plugin' ),
      'param_name' => 'p_arrows_display_next_name',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
      'dependency' => array(
  			'element' => 'pagination_arrows',
  			'not_empty' => true,
  		),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Next link title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'p_arrow_next_title',
      'save_always' => true,
      'value' => esc_html__( 'Next Review', 'wplab-albedo-core-plugin' ),
      'dependency' => array(
        'element' => 'p_arrows_display_next_name',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Autoplay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Autoplay speed', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in milliseconds, e.g.: 2000 = 2 seconds', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_speed',
      'save_always' => true,
      'value' => '2000',
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Stop on last slide', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enable this parameter and autoplay will be stopped when it reaches last slide (has no effect in loop mode)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_stop_on_last',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Disable autoplay on iteration', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set to false and autoplay will not be disabled after user interactions, it will be restarted every time after interaction', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_disable_on_interaction',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Loop slider', 'wplab-albedo-core-plugin' ),
      'param_name' => 'loop',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel Settings', 'wplab-albedo-core-plugin'),
    ),

  )

));
