<?php

  /**
    * Testimonials Grid Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Testimonials_Grid extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

    		/** load static stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-testimonials-grid', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/testimonials_grid.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/testimonials_grid_variable.less') );
        wp_enqueue_style( 'wplab-albedo-testimonials-grid-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/

        wp_dequeue_script( 'isotope');
        wp_register_script( 'albedo-isotope', wplab_albedo_utils::locate_uri( '/js/libs/isotope.pkgd.min.js'), array( 'jquery' ), _WPLAB_ALBEDO_CACHE_TIME_, true );
     		wp_enqueue_script( 'albedo-isotope' );

    		wp_enqueue_style( 'masonry-effects', get_template_directory_uri() . '/css/libs/masonry_effects.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_script( 'anim-on-scroll' );
    		wp_enqueue_script( 'wplab-albedo-testimonials-grid', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/testimonials-grid/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

        $custom_css = '';

        /** custom fonts **/
        if( filter_var( $atts['custom_font_family'], FILTER_VALIDATE_BOOLEAN ) ) {

          $fontsData = $this->getFontsData( $atts, 'google_fonts' );

        	$googleFontsStyles = $this->googleFontsStyles( $fontsData );
        	$this->enqueueGoogleFonts( $fontsData );

          $custom_css .= '#' . $shortcode_id . ' .text { ' . implode( ';', $googleFontsStyles ) . '; }';
        }

        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_testimonials_grid.php';
        return ob_get_clean();

      }

      protected function getFontsData( $atts, $paramName ) {
    		$googleFontsParam = new Vc_Google_Fonts();
    		$field = WPBMap::getParam( $this->shortcode, $paramName );
    		$fieldSettings = isset( $field['settings'], $field['settings']['fields'] ) ? $field['settings']['fields'] : array();
    		$fontsData = strlen( $atts[ $paramName ] ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $atts[ $paramName ] ) : '';

    		return $fontsData;
    	}

    	protected function googleFontsStyles( $fontsData ) {
    		// Inline styles
    		$fontFamily = explode( ':', $fontsData['values']['font_family'] );
    		$styles[] = 'font-family:' . $fontFamily[0];
    		$fontStyles = explode( ':', $fontsData['values']['font_style'] );
    		$styles[] = 'font-weight:' . $fontStyles[1];
    		$styles[] = 'font-style:' . $fontStyles[2];

    		return $styles;
    	}

    	protected function enqueueGoogleFonts( $fontsData ) {
    		// Get extra subsets for settings (latin/cyrillic/etc)
    		$settings = get_option( 'wpb_js_google_fonts_subsets' );
    		if ( is_array( $settings ) && ! empty( $settings ) ) {
    			$subsets = '&subset=' . implode( ',', $settings );
    		} else {
    			$subsets = '';
    		}

    		// We also need to enqueue font from googleapis
    		if ( isset( $fontsData['values']['font_family'] ) ) {
    			wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets );
    		}
    	}

    }
  }
