<?php

  /**
    * Iconic Tabs Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Tabs_Iconic extends WPBakeryShortCodesContainer {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;
        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        WPBakeryShortCode_Albedo_Tabs_Single::$parent_atts = $_SESSION['albedo_iconic_tabs_shortcode_atts'] = $atts;

        $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /**
         * Shortcode styles
         **/

        $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load static stylesheet **/
        wp_enqueue_style( 'wplab-albedo-tabs-iconic', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/tabs_iconic.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/tabs_iconic_variable.less') );
        wp_enqueue_style( 'wplab-albedo-tabs-iconic-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        /**
         * Shortcode scripts
         **/
        wp_enqueue_script( 'wplab-albedo-tabs-iconic', $wplab_albedo_core_plugin->plugin_uri . '/shortcodes/tabs-iconic/js/front' . $postfix . '.js', array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_tabs_iconic.php';
        return ob_get_clean();

      }

    }
  }
  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Tabs_Iconic_Single extends WPBakeryShortCode {
      public static $parent_atts;
    }
  }
