<?php

  /**
    * Video Lightbox Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Svg_Icon extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );

        $css_classes = $icon_attributes = array();

        /** include scripts **/
    		if( filter_var( $atts['is_lightbox'], FILTER_VALIDATE_BOOLEAN ) ) {
    			wp_enqueue_style( 'lightgallery', get_template_directory_uri() . '/css/libs/lightgallery.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    			wp_enqueue_style( 'lightgallery-transitions', get_template_directory_uri() . '/css/libs/lg-transitions.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    			wp_enqueue_script( 'lightgallery');
    			$js_vars = array();

    			$js_vars['lightboxEffect'] = fw_get_db_customizer_option( 'lightbox_effect' );
    			$js_vars['lightboxEasing'] = fw_get_db_customizer_option( 'lightbox_easing' );
    			$js_vars['lightboxThumbs'] = filter_var( fw_get_db_customizer_option( 'lightbox_thumbnails' ), FILTER_VALIDATE_BOOLEAN );
    			$js_vars['lightboxCaptions'] = filter_var( fw_get_db_customizer_option( 'lightbox_captions' ), FILTER_VALIDATE_BOOLEAN );
    			$js_vars['lightboxFullscreen'] = false;
    			$js_vars['lightboxZoom'] = false;
    			$js_vars['lightboxDownload'] = false;
    			$js_vars['lightboxAutoplay'] = filter_var( fw_get_db_customizer_option( 'lightbox_autoplay/enabled' ), FILTER_VALIDATE_BOOLEAN );
    			$js_vars['lightboxAutoplaySpeed'] = fw_get_db_customizer_option( 'lightbox_autoplay/yes/speed' );

    			if( $js_vars['lightboxThumbs'] == true ) {
    				wp_enqueue_script( 'lightgallery-thumb');
    			}
    			if( $js_vars['lightboxAutoplay'] == true ) {
    				wp_enqueue_script( 'lightgallery-autoplay');
    			}

    			wp_enqueue_script( 'lightgallery-video');
    			wp_enqueue_script( 'wplab-image-svg', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/svg-icon/static/js/lightbox.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );
    			wp_localize_script( 'wplab-image-svg', 'wplabAlbedoSVGIcon', $js_vars );
    		}

    		$inline_css = ' #' . $shortcode_id . ' svg {';

    		$inline_css .= 'display: inline-block; width: ' . $atts['width'] . 'px; max-width: 100%; height: ' . $atts['height'] . 'px;';

    		/**
    		 * Custom margins, paddings and borders
    		 **/

         if( $atts['margins'] <> '' ) {
          $sides_data = explode( '|', $atts['margins'] );
          $inline_css .= wplab_albedo_utils::get_styles( array(
          	'top_margin' 		=> $sides_data[0],
          	'right_margin' 	=> $sides_data[1],
          	'bottom_margin' => $sides_data[2],
          	'left_margin' 	=> $sides_data[3],
          ), '' );
     		}

    		$inline_css .= '}';

    		if( isset( $atts['color'] ) && $atts['color'] <> '' ) {
    			$inline_css .= ' #' . $shortcode_id . ' svg path, #' . $shortcode_id . ' svg circle, #' . $shortcode_id . ' svg rect { fill: ' . $atts['color'] . '; }';
    		}

    		$icon_attributes[] = 'data-custom-css=\'' . $inline_css . '\'';

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_svg_icon.php';
        return ob_get_clean();

      }

    }

  }
