<?php

/**
 * Header shortcode
 **/

require_once 'config.php';

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Albedo_Heading extends WPBakeryShortCode {

    protected function content( $atts, $content = null ) {

      $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
      $attributes = $classes = array();

      $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );
      $custom_css = '';

      /**
       * Custom CSS Classes
       **/
      if( $atts['custom_classes'] <> '' ) {
      	$classes[] = esc_attr( $atts['custom_classes'] );
      }

      /**
       * Animations
       **/
      if( filter_var( $atts['animation'], FILTER_VALIDATE_BOOLEAN ) ) {
      	$classes[] = 'wow';
      	$classes[] = $atts['animation_effect'];
      	$attributes[] = 'data-wow-delay="' . esc_attr( $atts['animation_delay'] ) . '"';
      }

      if( filter_var( $atts['disable_br'], FILTER_VALIDATE_BOOLEAN ) ) {
      	$classes[] = 'disable-br';
      }

      if( filter_var( $atts['typed_animation'], FILTER_VALIDATE_BOOLEAN ) ) {
      	$classes[] = 'typed';
      	$classes[] = 'wow';
      	$attributes[] = 'data-typed-speed="' . esc_attr( $atts['typed_speed'] ) . '"';
      	$attributes[] = 'data-typed-delay="' . esc_attr( $atts['typed_delay'] ) . '"';
      }

      if( $atts['header_color'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { color: ' . $atts['header_color'] . '; }';
      }

      if( $atts['text_align'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { text-align: ' . $atts['text_align'] . '; }';
      }

      if( $atts['text_transform'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { text-transform: ' . $atts['text_transform'] . '; }';
      }

      if( $atts['font_style'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { font-style: ' . $atts['font_style'] . '; }';
      }

      if( $atts['font_variant'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { font-variant: ' . $atts['font_variant'] . '; }';
      }

      if( $atts['font_weight'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { font-weight: ' . $atts['font_weight'] . '; }';
      }

      if( $atts['font_size'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { font-size: ' . $atts['font_size'] . 'px; }';
      }

      if( $atts['line_height'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { line-height: ' . $atts['line_height'] . 'px; }';
      }

      if( $atts['letter_spacing'] <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' { letter-spacing: ' . $atts['letter_spacing'] . '; }';
      }

      /**
       * Custom margins
       **/
      $inline_css = '';
      if( $atts['margins'] <> '' ) {
        $sides_data = explode( '|', $atts['margins'] );
        $inline_css = wplab_albedo_utils::get_styles( array(
          'top_margin' 		=> $sides_data[0],
          'right_margin' 	=> $sides_data[1],
          'bottom_margin' 	=> $sides_data[2],
          'left_margin' 		=> $sides_data[3],
        ), '' );
      }

      if( $inline_css <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' {' . $inline_css . '}';
      }

      /**
       * Custom paddings
       **/
      $inline_css = '';
      if( $atts['paddings'] <> '' ) {
        $sides_data = explode( '|', $atts['paddings'] );
        $inline_css = wplab_albedo_utils::get_styles( array(
          'top_padding' 		=> $sides_data[0],
          'right_padding' 	=> $sides_data[1],
          'bottom_padding' 	=> $sides_data[2],
          'left_padding' 		=> $sides_data[3],
        ), '' );
      }

      if( $inline_css <> '' ) {
        $custom_css .= ' #' . $shortcode_id . ' {' . $inline_css . '}';
      }

      if( filter_var( $atts['custom_font_family'], FILTER_VALIDATE_BOOLEAN ) ) {

        $fontsData = $this->getFontsData( $atts, 'google_fonts' );

        $googleFontsStyles = $this->googleFontsStyles( $fontsData );
        $this->enqueueGoogleFonts( $fontsData );

        $custom_css .= '#' . $shortcode_id . ' { ' . implode( ';', $googleFontsStyles ) . '; }';
      }

      /**
  		 * Typed animation
  		 **/
  		if( filter_var( $atts['typed_animation'], FILTER_VALIDATE_BOOLEAN ) ) {
  			wp_enqueue_script( 'typed');
  		}

      /**
  		 * Responsive settings
  		 **/
  		$inline_css = '';

  		if( isset( $atts['font_size_mobile'] ) && $atts['font_size_mobile'] <> '' ) {
  			$inline_css .= 'font-size: ' . $atts['font_size_mobile'] . 'px;';
  		}

  		if( isset( $atts['line_height_mobile'] ) && $atts['line_height_mobile'] <> '' ) {
  			$inline_css .= 'line-height: ' . $atts['line_height_mobile'] . 'px;';
  		}

  		if( $inline_css <> '' ) {
  			$custom_css .= ' @media screen and (max-width: 992px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
  		}

      if( $atts['custom_css'] ) {
        $custom_css .= ' #' . $shortcode_id . ' {' . $atts['custom_css'] . '}';
      }

      $attributes[] = 'id="' . $shortcode_id . '"';
      if( $custom_css <> '' ) {
        $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
      }

      ob_start();
      require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_heading.php';
      return ob_get_clean();
    }

    protected function getFontsData( $atts, $paramName ) {
      $googleFontsParam = new Vc_Google_Fonts();
      $field = WPBMap::getParam( $this->shortcode, $paramName );
      $fieldSettings = isset( $field['settings'], $field['settings']['fields'] ) ? $field['settings']['fields'] : array();
      $fontsData = strlen( $atts[ $paramName ] ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $atts[ $paramName ] ) : '';

      return $fontsData;
    }

    protected function googleFontsStyles( $fontsData ) {
      // Inline styles
      $fontFamily = explode( ':', $fontsData['values']['font_family'] );
      $styles[] = 'font-family:' . $fontFamily[0];
      $fontStyles = explode( ':', $fontsData['values']['font_style'] );
      $styles[] = 'font-weight:' . $fontStyles[1];
      $styles[] = 'font-style:' . $fontStyles[2];

      return $styles;
    }

    protected function enqueueGoogleFonts( $fontsData ) {
      // Get extra subsets for settings (latin/cyrillic/etc)
      $settings = get_option( 'wpb_js_google_fonts_subsets' );
      if ( is_array( $settings ) && ! empty( $settings ) ) {
        $subsets = '&subset=' . implode( ',', $settings );
      } else {
        $subsets = '';
      }

      // We also need to enqueue font from googleapis
      if ( isset( $fontsData['values']['font_family'] ) ) {
        wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets );
      }
    }

  }
}
