<?php

  /**
    * Services Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Services extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load static stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-services-iconic', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/services_iconic.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/services_iconic_variable.less') );
        wp_enqueue_style( 'wplab-albedo-services-iconic-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-services-iconic', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/services-iconic/static/js/scripts.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

    		/**
    		 * Custom colors
    		 **/

        $custom_css = '';

    		if( $atts['icon_color'] <> '' ) {

    			$inline_css = ' #' . $shortcode_id . ' .icon { color: ' . $atts['icon_color'] . '; }';
    			$inline_css .= ' #' . $shortcode_id . ' svg path, #' . $shortcode_id . ' svg rect, #' . $shortcode_id . ' svg polygon, #' . $shortcode_id . ' svg circle { fill: ' . $atts['icon_color'] . '; }';
    			$custom_css .= $inline_css;

    		}

    		if( $atts['icon_hover_color'] <> '' ) {

    			$inline_css = ' #' . $shortcode_id . ' .item:hover .icon { color: ' . $atts['icon_hover_color'] . '; }';
    			$inline_css .= ' #' . $shortcode_id . ' .item:hover svg path, #' . $shortcode_id . ' .item:hover svg rect, #' . $shortcode_id . ' .item:hover svg polygon, #' . $shortcode_id . ' .item:hover svg circle { fill: ' . $atts['icon_hover_color'] . '; }';
    			$custom_css .= $inline_css;

    		}

    		if( $atts['category_color'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' .category { color: ' . $atts['category_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( $atts['header_color'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' h4 { color: ' . $atts['header_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( $atts['header_hover_color'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' .item:hover h4 { color: ' . $atts['header_hover_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( $atts['text_color'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' .desc { color: ' . $atts['text_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( $atts['list_text_color'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' ul li { color: ' . $atts['list_text_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

    		if( $atts['list_bullets_color'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' ul li:before { background-image: url("data:image/svg+xml;charset=UTF-8,%3Csvg%20version%3D%221.1%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20x%3D%220px%22%20y%3D%220px%22%20width%3D%22415.582px%22%20height%3D%22415.582px%22%20viewBox%3D%220%200%20415.582%20415.582%22%20style%3D%22enable-background%3Anew%200%200%20415.582%20415.582%3B%22%20xml%3Aspace%3D%22preserve%22%3E%3Cg%3E%3Cpath%20fill%3D%22' . urlencode( $atts['list_bullets_color'] ) . '%22%20d%3D%22M411.47%2C96.426l-46.319-46.32c-5.482-5.482-14.371-5.482-19.853%2C0L152.348%2C243.058l-82.066-82.064%20c-5.48-5.482-14.37-5.482-19.851%2C0l-46.319%2C46.32c-5.482%2C5.481-5.482%2C14.37%2C0%2C19.852l138.311%2C138.31%20c2.741%2C2.742%2C6.334%2C4.112%2C9.926%2C4.112c3.593%2C0%2C7.186-1.37%2C9.926-4.112L411.47%2C116.277c2.633-2.632%2C4.111-6.203%2C4.111-9.925%20C415.582%2C102.628%2C414.103%2C99.059%2C411.47%2C96.426z%22%2F%3E%3C%2Fg%3E%3C%2Fsvg%3E");; }';
    			$custom_css .= $inline_css;
    		}

        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_services.php';
        return ob_get_clean();

      }

    }
  }
