<?php

vc_map( array(
  'name' => esc_html__( 'Quote', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_quote',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/quote.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/quote/js/vc.js',
	'category' => esc_html__( 'Testimonials', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add quote / cite', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/

    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Quote text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Author', 'wplab-albedo-core-plugin' ),
      'param_name' => 'author',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Position', 'wplab-albedo-core-plugin' ),
      'param_name' => 'position',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Background photo', 'wplab-albedo-core-plugin'),
      'param_name' => 'bg_image',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Signature photo', 'wplab-albedo-core-plugin'),
      'param_name' => 'sign_image',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'value' => array(
        esc_html__('White, dark text', 'wplab-albedo-core-plugin') => 'white',
        esc_html__('Dark, white text', 'wplab-albedo-core-plugin') => 'dark',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Styling tab
    **/
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Quote Paddings', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Quote Paddings (for medium screens)', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings_medium',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Quote Paddings (for small screens)', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings_mobile',
       'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Custom font family', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_font_family',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
			'type' => 'google_fonts',
			'param_name' => 'google_fonts',
			'value' => '',
      'dependency' => array(
  			'element' => 'custom_font_family',
  			'not_empty' => true,
  		),
			'settings' => array(
				'fields' => array(
					'font_family_description' => __( 'Select font family.', 'wplab-albedo-core-plugin' ),
					'font_style_description' => __( 'Select font styling.', 'wplab-albedo-core-plugin' ),
				),
			),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
		),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Background image position', 'wplab-albedo-core-plugin'),
      'param_name' => 'background_position',
      'save_always' => true,
      'value' => array(
        esc_html__('Top Left', 'wplab-albedo-core-plugin') => 'left top',
        esc_html__('Top Center', 'wplab-albedo-core-plugin') => 'center top',
        esc_html__('Top Right', 'wplab-albedo-core-plugin') => 'right top',
        esc_html__('Middle Left', 'wplab-albedo-core-plugin') => 'left center',
        esc_html__('Middle Center', 'wplab-albedo-core-plugin') => 'center',
        esc_html__('Middle Right', 'wplab-albedo-core-plugin') => 'right center',
        esc_html__('Bottom Left', 'wplab-albedo-core-plugin') => 'left bottom',
        esc_html__('Bottom Right', 'wplab-albedo-core-plugin') => 'right bottom',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Background image repeat', 'wplab-albedo-core-plugin'),
      'param_name' => 'background_repeat',
      'save_always' => true,
      'value' => array(
        esc_html__('No repeat', 'wplab-albedo-core-plugin') => 'no-repeat',
        esc_html__('Repeat horizontally', 'wplab-albedo-core-plugin') => 'repeat-x',
        esc_html__('Repeat vertically', 'wplab-albedo-core-plugin') => 'repeat-y',
        esc_html__('Repeat horizontally and vertically', 'wplab-albedo-core-plugin') => 'repeat',
      ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Lazy Load Background Image', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'If enabled, background image will be loaded through JavaScript after text content', 'wplab-albedo-core-plugin' ),
      'param_name' => 'background_lazy',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Cover Background Image', 'wplab-albedo-core-plugin' ),
      'param_name' => 'background_cover',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Animations tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Text animation effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'text_animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'group' => esc_html__('Animations', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Text animation delay', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'For example: 0.3s', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text_animation_delay',
      'save_always' => true,
      'value' => '0.1s',
      'group' => esc_html__('Animations', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Signature animation effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'sign_animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'group' => esc_html__('Animations', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Signature animation delay', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'For example: 0.3s', 'wplab-albedo-core-plugin' ),
      'param_name' => 'sign_animation_delay',
      'save_always' => true,
      'value' => '0.2s',
      'group' => esc_html__('Animations', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Author animation effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'author_animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'group' => esc_html__('Animations', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Author animation delay', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'For example: 0.3s', 'wplab-albedo-core-plugin' ),
      'param_name' => 'author_animation_delay',
      'save_always' => true,
      'value' => '0.3s',
      'group' => esc_html__('Animations', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Position animation effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'position_animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'group' => esc_html__('Animations', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Position animation delay', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'For example: 0.3s', 'wplab-albedo-core-plugin' ),
      'param_name' => 'position_animation_delay',
      'save_always' => true,
      'value' => '0.4s',
      'group' => esc_html__('Animations', 'wplab-albedo-core-plugin'),
    ),

  )
));
