(function ( $ ) {

	function albedo_blog_masonry_refresh( element ) {

		var $iframe = $("#vc_inline-frame"),
		iframeContents = $iframe.contents(),
		contentWindow = $iframe[0].contentWindow,
		$element = element.$el.find('.shortcode-blog-masonry'),
		elementId = $element.attr('id'),
		cssId = 'albedo-custom-css-id-' + elementId;

		iframeContents.find('#' + cssId).remove();
		iframeContents.find("head").append('<!-- auto generated custom css by element / shortcode --><style type="text/css" id="' + cssId + '">' + $element.data('custom-css') + '</style>');

		contentWindow.themeFrontCore.initLazyLoading();
		contentWindow.themeFrontCore.loadSVG();

		if( 'albedo_blog_masonry_init' in contentWindow ) {
			contentWindow.albedo_blog_masonry_init();
		} else {
			setTimeout( function() {
				contentWindow.albedo_blog_masonry_init();
			}, 500 );
		}

	}

	window.InlineShortcodeView_albedo_blog_masonry = window.InlineShortcodeView.extend({
		render: function () {

			window.InlineShortcodeView_albedo_blog_masonry.__super__.render.call( this );
			albedo_blog_masonry_refresh( this );

		  return this;
		},
		updated: function() {
			_.each(vc.shortcodes.where({
					parent_id: this.model.get("id")
			}), function(model) {
					model.view.parent_view = this, model.view.parentChanged()
			}, this), _.defer(_.bind(function() {
					vc.events.trigger("shortcodeView:updated", this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("shortcode"), this.model), vc.events.trigger("shortcodeView:updated:" + this.model.get("id"), this.model)
			}, this))

			// wait until element will be fully loaded
			var instance = this;
	    $(document).ajaxStop(function () {
				albedo_blog_masonry_refresh( instance );
			});

		}
	});

})( window.jQuery );
