<?php

  /**
    * Blockquote Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Blockquote extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );
        $custom_css = '';

        if( $atts['background_color'] <> '' ) {
          $custom_css .= ' #' . $shortcode_id . ' { background-color: ' . $atts['background_color'] . ';} ';
    		}

    		if( $atts['text_color'] <> '' ) {
          $custom_css .= ' #' . $shortcode_id . ' p, #' . $shortcode_id . ' .text { color: ' . $atts['text_color'] . '; }';
    		}

    		if( $atts['author_color'] <> '' ) {
          $custom_css .= ' #' . $shortcode_id . ' .author { color: ' . $atts['author_color'] . '; }';
    		}

    		if( $atts['position_color'] <> '' ) {
          $custom_css .= ' #' . $shortcode_id . ' .position { color: ' . $atts['position_color'] . '; }';
    		}

    		if( $atts['quotes_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' { background-image:url("data:image/svg+xml;charset=UTF-8,%3Csvg%20version%3D%221.1%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20x%3D%220px%22%20y%3D%220px%22%20width%3D%2295.333px%22%20height%3D%2295.332px%22%20viewBox%3D%220%200%2095.333%2095.332%22%20style%3D%22enable-background%3Anew%200%200%2095.333%2095.332%3B%22%20xml%3Aspace%3D%22preserve%22%3E%3Cg%3E%3Cg%3E%3Cpath%20fill%3D%22' . urlencode( $atts['quotes_color'] ) . '%22%20d%3D%22M30.512%2C43.939c-2.348-0.676-4.696-1.019-6.98-1.019c-3.527%2C0-6.47%2C0.806-8.752%2C1.793%20c2.2-8.054%2C7.485-21.951%2C18.013-23.516c0.975-0.145%2C1.774-0.85%2C2.04-1.799l2.301-8.23c0.194-0.696%2C0.079-1.441-0.318-2.045%20s-1.035-1.007-1.75-1.105c-0.777-0.106-1.569-0.16-2.354-0.16c-12.637%2C0-25.152%2C13.19-30.433%2C32.076%20c-3.1%2C11.08-4.009%2C27.738%2C3.627%2C38.223c4.273%2C5.867%2C10.507%2C9%2C18.529%2C9.313c0.033%2C0.001%2C0.065%2C0.002%2C0.098%2C0.002%20c9.898%2C0%2C18.675-6.666%2C21.345-16.209c1.595-5.705%2C0.874-11.688-2.032-16.851C40.971%2C49.307%2C36.236%2C45.586%2C30.512%2C43.939z%22%2F%3E%3Cpath%20fill%3D%22' . urlencode( $atts['quotes_color'] ) . '%22%20d%3D%22M92.471%2C54.413c-2.875-5.106-7.61-8.827-13.334-10.474c-2.348-0.676-4.696-1.019-6.979-1.019%20c-3.527%2C0-6.471%2C0.806-8.753%2C1.793c2.2-8.054%2C7.485-21.951%2C18.014-23.516c0.975-0.145%2C1.773-0.85%2C2.04-1.799l2.301-8.23%20c0.194-0.696%2C0.079-1.441-0.318-2.045c-0.396-0.604-1.034-1.007-1.75-1.105c-0.776-0.106-1.568-0.16-2.354-0.16%20c-12.637%2C0-25.152%2C13.19-30.434%2C32.076c-3.099%2C11.08-4.008%2C27.738%2C3.629%2C38.225c4.272%2C5.866%2C10.507%2C9%2C18.528%2C9.312%20c0.033%2C0.001%2C0.065%2C0.002%2C0.099%2C0.002c9.897%2C0%2C18.675-6.666%2C21.345-16.209C96.098%2C65.559%2C95.376%2C59.575%2C92.471%2C54.413z%22%2F%3E%3C%2Fg%3E%3C%2Fg%3E%3C%2Fsvg%3E"); }';
    		}

        /**
    		 * Custom margins
    		 **/
    		$inline_css = '';
    		if( $atts['margins'] <> '' ) {
          $sides_data = explode( '|', $atts['margins'] );
    			$inline_css = wplab_albedo_utils::get_styles( array(
    				'top_margin' 		=> $sides_data[0],
    				'right_margin' 	=> $sides_data[1],
    				'bottom_margin' => $sides_data[2],
    				'left_margin' 	=> $sides_data[3],
    			), '' );
    		}

    		if( $inline_css <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' {' . $inline_css . '}';
    		}

    		/**
    		 * Responsiveness, medium screen
    		 **/
    		$inline_css = '';
  			if( $atts['margins_medium'] <> '' ) {
          $sides_data = explode( '|', $atts['margins_medium'] );
  				$inline_css = wplab_albedo_utils::get_styles( array(
  					'top_margin' 		=> $sides_data[0],
  					'right_margin' 	=> $sides_data[1],
  					'bottom_margin' => $sides_data[2],
  					'left_margin' 	=> $sides_data[3],
  				), '' );
  			}

    		if( $inline_css <> '' ) {
    			$custom_css .= '@media screen and (max-width: 992px) and (min-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
    		}

    		/**
    		 * Responsiveness, small screen
    		 **/
    		$inline_css = '';

  			if( $atts['margins_mobile'] <> '' ) {
          $sides_data = explode( '|', $atts['margins_mobile'] );
  				$inline_css = wplab_albedo_utils::get_styles( array(
  					'top_margin' 		=> $sides_data[0],
  					'right_margin' 	=> $sides_data[1],
  					'bottom_margin' => $sides_data[2],
  					'left_margin' 	=> $sides_data[3],
  				), '' );
  			}

    		if( $inline_css <> '' ) {
    			$custom_css .= '@media screen and (max-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
    		}


    		/**
    		 * Custom paddings
    		 **/
    		$inline_css = '';
    		if( $atts['paddings'] <> '' ) {
          $sides_data = explode( '|', $atts['paddings'] );
    			$inline_css = wplab_albedo_utils::get_styles( array(
    				'top_padding' 		=> $sides_data[0],
    				'right_padding' 	=> $sides_data[1],
    				'bottom_padding' 	=> $sides_data[2],
    				'left_padding' 		=> $sides_data[3],
    			), '' );
    		}

    		if( $inline_css <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' {' . $inline_css . '}';
    		}

    		/**
    		 * Responsiveness, medium screen
    		 **/
    		$inline_css = '';

    			if( $atts['paddings_medium'] <> '' ) {
            $sides_data = explode( '|', $atts['paddings_medium'] );
    				$inline_css = wplab_albedo_utils::get_styles( array(
    					'top_padding' 		=> $sides_data[0],
    					'right_padding' 	=> $sides_data[1],
    					'bottom_padding' 	=> $sides_data[2],
    					'left_padding' 		=> $sides_data[3],
    				), '' );
    			}

    		if( $inline_css <> '' ) {
    			$custom_css .= '@media screen and (max-width: 992px) and (min-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
    		}

    		/**
    		 * Responsiveness, small screen
    		 **/
    		$inline_css = '';

    			if( $atts['paddings_mobile'] <> '' ) {
            $sides_data = explode( '|', $atts['paddings_mobile'] );
    				$inline_css = wplab_albedo_utils::get_styles( array(
    					'top_padding' 		=> $sides_data[0],
    					'right_padding' 	=> $sides_data[1],
    					'bottom_padding' 	=> $sides_data[2],
    					'left_padding' 		=> $sides_data[3],
    				), '' );
    			}

    		if( $inline_css <> '' ) {
    			$custom_css .= '@media screen and (max-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
    		}

        if( filter_var( $atts['custom_font_family'], FILTER_VALIDATE_BOOLEAN ) ) {

          $fontsData = $this->getFontsData( $atts, 'google_fonts' );

        	$googleFontsStyles = $this->googleFontsStyles( $fontsData );
        	$this->enqueueGoogleFonts( $fontsData );

          $custom_css .= '#' . $shortcode_id . ' p, #' . $shortcode_id . ' .text { ' . implode( ';', $googleFontsStyles ) . '; }';
        }

        $attributes[] = 'id="' . $shortcode_id . '"';
        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blockquote.php';
        return ob_get_clean();
    	}

      protected function getFontsData( $atts, $paramName ) {
    		$googleFontsParam = new Vc_Google_Fonts();
    		$field = WPBMap::getParam( $this->shortcode, $paramName );
    		$fieldSettings = isset( $field['settings'], $field['settings']['fields'] ) ? $field['settings']['fields'] : array();
    		$fontsData = strlen( $atts[ $paramName ] ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $atts[ $paramName ] ) : '';

    		return $fontsData;
    	}

    	protected function googleFontsStyles( $fontsData ) {
    		// Inline styles
    		$fontFamily = explode( ':', $fontsData['values']['font_family'] );
    		$styles[] = 'font-family:' . $fontFamily[0];
    		$fontStyles = explode( ':', $fontsData['values']['font_style'] );
    		$styles[] = 'font-weight:' . $fontStyles[1];
    		$styles[] = 'font-style:' . $fontStyles[2];

    		return $styles;
    	}

    	protected function enqueueGoogleFonts( $fontsData ) {
    		// Get extra subsets for settings (latin/cyrillic/etc)
    		$settings = get_option( 'wpb_js_google_fonts_subsets' );
    		if ( is_array( $settings ) && ! empty( $settings ) ) {
    			$subsets = '&subset=' . implode( ',', $settings );
    		} else {
    			$subsets = '';
    		}

    		// We also need to enqueue font from googleapis
    		if ( isset( $fontsData['values']['font_family'] ) ) {
    			wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets );
    		}
    	}

    }
  }
