<?php

  /**
    * Benefits With Filters Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Benefits_Filters extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        fw()->backend->option_type('icon-v2')->packs_loader->enqueue_frontend_css();

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-benefits_v2', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/benefits_v2.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/benefits_v2_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-benefits_v2-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/** include Masonry Grid **/
    		wp_enqueue_style( 'masonry', get_template_directory_uri() . '/css/libs/masonry.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_style( 'masonry-effects', get_template_directory_uri() . '/css/libs/masonry_effects.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );

        wp_dequeue_script( 'isotope');
        wp_register_script( 'albedo-isotope', wplab_albedo_utils::locate_uri( '/js/libs/isotope.pkgd.min.js'), array( 'jquery' ), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_enqueue_script( 'albedo-isotope' );
    		wp_enqueue_script( 'anim-on-scroll' );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'sticky-kit');
    		wp_enqueue_script( 'wplab-albedo-benefits_v2', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/benefits-v2/static/js/scripts' . $postfix . '.js'), array('jquery', 'albedo-isotope'), _WPLAB_ALBEDO_CACHE_TIME_, true );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_benefits_v2.php';
        return ob_get_clean();

      }

    }
  }
