<?php

vc_map( array(
  'name' => esc_html__( 'Benefits Modern', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_benefits_modern',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/benefits-modern.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/benefits-modern/js/vc.js',
	'category' => esc_html__( 'Services', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add benefits', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     * General tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All Benefits', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Benefits only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Benefits except categories', 'wplab-albedo-core-plugin') => 'except',
        esc_html__('Display child posts from selected category', 'wplab-albedo-core-plugin') => 'all_child',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Benefits count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '10',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'value' => '',
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Style tab
    **/

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'admin_label' => true,
      'value' => array(
        esc_html__('For white backgrounds', 'wplab-albedo-core-plugin') => 'white',
        esc_html__('For colorful backgrounds', 'wplab-albedo-core-plugin') => 'colorful',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Accent color', 'wplab-albedo-core-plugin'),
      'param_name' => 'accent_color',
      'value' => $this->cfg['base_colors'],
      'dependency' => array(
  			'element' => 'style',
  			'value' => array( 'colorful' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'cols',
      'value' => array(
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Open links at new tab', 'wplab-albedo-core-plugin' ),
      'param_name' => 'link_target',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_button',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),


    /**
     * Animation tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on display', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_display_effect',
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Time step', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_display_step',
      'value' => '0.2',
      'dependency' => array(
  			'element' => 'animate_on_display',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on hover', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_hover',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_hover_effect',
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_hover',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),

    /**
     * Colors tab
    **/
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Icon color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'icon_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Icon hover color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'icon_hover_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Header color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'header_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Header hover color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'header_hover_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'text_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Decor color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'decor_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Button color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'button_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Button hover color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'button_hover_color',
  		'value' => '',
  		'group' => esc_html__('Colors', 'wplab-albedo-core-plugin'),
  	),

  )
));
