<?php
/*
	Plugin Name: WPlab Albedo Core
	Plugin URI: http://www.albedo-theme.com
	Description: This plugin provides Custom Post Types and adds Albedo Theme Elements for Visual Composer (if active).
	Version: 1.0.11
	Author: wplab.pro
	Author URI: http://www.albedo-theme.com
*/

define( '_WPLAB_ALBEDO_CORE_CACHE_TIME_', '270120181216');

// check for updates
require_once plugin_dir_path( __FILE__ ) . '/updater/plugin-update-checker.php';

$albedo_core_updater = Puc_v4_Factory::buildUpdateChecker(
	'http://update.albedo-theme.com/?action=get_metadata&slug=wplab-albedo-core',
	__FILE__,
	'wplab-albedo-core'
);

class wplab_albedo_core_plugin {

	public $cfg;
	public $is_unyson;
	public $is_vc;
	public $postfix;
	public $tpl_url;
	public $cache_time;
	public $plugin_uri;
	public $plugin_src;

	function __construct() {

		// Translation support
		load_plugin_textdomain( 'wplab-albedo-core-plugin', false, plugin_dir_path( __FILE__ ) . '/languages' );

		// Add CSS styles
		add_action( 'wp_enqueue_scripts', array( $this, 'add_front_styles' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'add_styles' ) );

		add_action( 'init', array( $this, 'init'), 1);

		// Register Custom Post Types and Taxonomies
		add_action( 'init', array( $this, 'register_custom_post_types'), 5);

		// Make Custom Post Titles visible in Unyson Page Builder
		// add_filter( 'fw_ext_page_builder_supported_post_types', array( $this, 'filter_unyson'), 10, 1);

		// Setup Visual Composer
		add_action( 'vc_before_init', array( $this, 'setup_vc'), 1 );

		// Add Custom Controls to Visual Composer
		add_action( 'vc_load_default_params', array( $this, 'register_custom_params') );

		// Add Shortcodes to Visual Composer
		add_action( 'vc_after_init', array( $this, 'register_vc_shortcodes') );

		// Add SSL support
		add_filter( 'vc_frontend_editor_iframe_url', array( $this, 'change_frontend_editor_iframe_url') );

	}

	/**
	 * Init the plugin
	 **/
	function init() {
		$this->is_unyson = defined('FW') && function_exists('fw_get_db_settings_option');
		$this->is_vc = in_array( 'js_composer/js_composer.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) );
		$this->postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
		$this->tpl_url = apply_filters( 'wplab_albedo_core_tpl_url', get_template_directory_uri() );
		$this->plugin_uri = plugin_dir_url( __FILE__ );
		$this->plugin_src = plugin_dir_path( __FILE__ );

		$this->cfg = array(
			'social_profiles' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Facebook URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'facebook_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Twitter URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'twitter_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Instagram URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'instagram_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Google Plus URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'google_plus_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Pinterest URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'pinterest_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'LinkedIn URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'linkedin_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'YouTube URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'youtube_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Vimeo URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'vimeo_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Dribbble URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'dribbble_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Behance URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'behance_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Tumblr URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'tumblr_url',
					'value' => '',
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Flickr URL', 'wplab-albedo-core-plugin' ),
					'param_name' => 'flickr_url',
					'value' => '',
				),
			),
			'social_icons' => array(
				'facebook_url' => 'fa fa-facebook',
				'twitter_url' => 'fa fa-twitter',
				'instagram_url' => 'fa fa-instagram',
				'google_plus_url' => 'fa fa-google-plus',
				'pinterest_url' => 'fa fa-pinterest-p',
				'linkedin_url' => 'fa fa-linkedin',
				'youtube_url' => 'fa fa-youtube-play',
				'vimeo_url' => 'fa fa-vimeo',
				'dribbble_url' => 'fa fa-dribbble',
				'behance_url' => 'fa fa-behance',
				'tumblr_url' => 'fa fa-tumblr',
				'flickr_url' => 'fa fa-flickr',
			),
			'animations' => array(
				esc_html__('Fade In', 'wplab-albedo-core-plugin') 								=> 'fadeIn',
				esc_html__('Fade In Down', 'wplab-albedo-core-plugin') 						=> 'fadeInDown',
				esc_html__('Fade In Down Big', 'wplab-albedo-core-plugin') 				=> 'fadeInDownBig',
				esc_html__('Fade In Left', 'wplab-albedo-core-plugin') 						=> 'fadeInLeft',
				esc_html__('Fade In Left Big', 'wplab-albedo-core-plugin') 				=> 'fadeInLeftBig',
				esc_html__('Fade In Right', 'wplab-albedo-core-plugin') 					=> 'fadeInRight',
				esc_html__('Fade In Right Big', 'wplab-albedo-core-plugin') 			=> 'fadeInRightBig',
				esc_html__('Fade In Up', 'wplab-albedo-core-plugin') 							=> 'fadeInUp',
				esc_html__('Fade In Up Big', 'wplab-albedo-core-plugin') 					=> 'fadeInUpBig',
				esc_html__('Bounce', 'wplab-albedo-core-plugin') 									=> 'bounce',
				esc_html__('Pulse', 'wplab-albedo-core-plugin') 									=> 'pulse',
				esc_html__('Tada', 'wplab-albedo-core-plugin') 										=> 'tada',
				esc_html__('Wobble', 'wplab-albedo-core-plugin') 									=> 'wobble',
				esc_html__('Jello', 'wplab-albedo-core-plugin') 									=> 'jello',
				esc_html__('Bounce In', 'wplab-albedo-core-plugin') 							=> 'bounceIn',
				esc_html__('Bounce In Down', 'wplab-albedo-core-plugin') 					=> 'bounceInDown',
				esc_html__('Bounce In Left', 'wplab-albedo-core-plugin') 					=> 'bounceInLeft',
				esc_html__('Bounce In Right', 'wplab-albedo-core-plugin') 				=> 'bounceInRight',
				esc_html__('Bounce In Up', 'wplab-albedo-core-plugin') 						=> 'bounceInUp',
				esc_html__('Flip', 'wplab-albedo-core-plugin') 										=> 'flip',
				esc_html__('Flip in X', 'wplab-albedo-core-plugin') 							=> 'flipInX',
				esc_html__('Flip in Y', 'wplab-albedo-core-plugin') 							=> 'flipInY',
				esc_html__('Flip out X', 'wplab-albedo-core-plugin') 							=> 'flipOutX',
				esc_html__('Flip out Y', 'wplab-albedo-core-plugin') 							=> 'flipOutY',
				esc_html__('Light Speed In', 'wplab-albedo-core-plugin') 					=> 'lightSpeedIn',
				esc_html__('Rotate In', 'wplab-albedo-core-plugin') 							=> 'rotateIn',
				esc_html__('Rotate In Down Left', 'wplab-albedo-core-plugin') 		=> 'rotateInDownLeft',
				esc_html__('Rotate In Down Right', 'wplab-albedo-core-plugin') 		=> 'rotateInDownRight',
				esc_html__('Rotate In Up Left', 'wplab-albedo-core-plugin') 			=> 'rotateInUpLeft',
				esc_html__('Rotate In Up Right', 'wplab-albedo-core-plugin') 			=> 'rotateInUpRight',
				esc_html__('Slide In Up', 'wplab-albedo-core-plugin') 						=> 'slideInUp',
				esc_html__('Slide In Down', 'wplab-albedo-core-plugin') 					=> 'slideInDown',
				esc_html__('Slide In Left', 'wplab-albedo-core-plugin') 					=> 'slideInLeft',
				esc_html__('Slide In Right', 'wplab-albedo-core-plugin') 					=> 'slideInRight',
				esc_html__('Zoom In', 'wplab-albedo-core-plugin') 								=> 'zoomIn',
				esc_html__('Zoom In Down', 'wplab-albedo-core-plugin') 						=> 'zoomInDown',
				esc_html__('Zoom In Left', 'wplab-albedo-core-plugin') 						=> 'zoomInLeft',
				esc_html__('Zoom In Right', 'wplab-albedo-core-plugin') 					=> 'zoomInRight',
				esc_html__('Zoom In Up', 'wplab-albedo-core-plugin') 							=> 'zoomInUp',
			),
			'overlay_effects' => array(
				esc_html__( 'Default', 'wplab-albedo-core-plugin' ) 										=> 'default',
				esc_html__( 'Slide (from right to left)', 'wplab-albedo-core-plugin' ) 	=> 'slide-right-left',
				esc_html__( 'Zoom Out', 'wplab-albedo-core-plugin' ) 										=> 'zoom-out',
				esc_html__( 'Zoom In', 'wplab-albedo-core-plugin' ) 										=> 'zoom-in',
				esc_html__( 'Big Zoom', 'wplab-albedo-core-plugin' ) 										=> 'big-zoom',
				esc_html__( 'Zoom 3D', 'wplab-albedo-core-plugin' ) 										=> 'zoom-3d',
				esc_html__( 'Zoom and Slide', 'wplab-albedo-core-plugin' ) 							=> 'zoom-slide',
				esc_html__( 'Shine', 'wplab-albedo-core-plugin' ) 											=> 'shine',
			),
			'base_colors' => array(
				esc_html__( 'Blue', 'wplab-albedo-core-plugin' ) 					=> 'blue',
				esc_html__( 'Black', 'wplab-albedo-core-plugin' ) 				=> 'black',
				esc_html__( 'White', 'wplab-albedo-core-plugin' ) 				=> 'white',
				esc_html__( 'Grey', 'wplab-albedo-core-plugin' ) 					=> 'grey',
				esc_html__( 'Light Grey', 'wplab-albedo-core-plugin' ) 		=> 'light_grey',
				esc_html__( 'Red', 'wplab-albedo-core-plugin' ) 					=> 'red',
				esc_html__( 'Orange', 'wplab-albedo-core-plugin' ) 				=> 'orange',
				esc_html__( 'Green', 'wplab-albedo-core-plugin' ) 				=> 'green',
				esc_html__( 'Turquoise', 'wplab-albedo-core-plugin' ) 		=> 'turquoise',
				esc_html__( 'Yellow', 'wplab-albedo-core-plugin' ) 				=> 'yellow',
				esc_html__( 'Purple', 'wplab-albedo-core-plugin' ) 				=> 'purple',
				esc_html__( 'Dark Purple', 'wplab-albedo-core-plugin' ) 	=> 'dark_purple',
			),
			'button_styles' => array(
				esc_html__( 'Blue', 'wplab-albedo-core-plugin' ) 								=> 'blue',
				esc_html__( 'Black', 'wplab-albedo-core-plugin' ) 							=> 'black',
				esc_html__( 'Grey', 'wplab-albedo-core-plugin' ) 								=> 'grey',
				esc_html__( 'Red', 'wplab-albedo-core-plugin' )									=> 'red',
				esc_html__( 'Orange', 'wplab-albedo-core-plugin' ) 							=> 'orange',
				esc_html__( 'Green', 'wplab-albedo-core-plugin' )								=> 'green',
				esc_html__( 'Turquoise', 'wplab-albedo-core-plugin' )						=> 'turquoise',
				esc_html__( 'Yellow', 'wplab-albedo-core-plugin' ) 							=> 'yellow',
				esc_html__( 'Purple', 'wplab-albedo-core-plugin' ) 							=> 'purple',
				esc_html__( 'Dark Purple', 'wplab-albedo-core-plugin' )					=> 'dark-purple',
				esc_html__( 'White', 'wplab-albedo-core-plugin' )								=> 'white',
				esc_html__( 'Blue Stroke', 'wplab-albedo-core-plugin' ) 				=> 'blue stroke',
				esc_html__( 'Black Stroke', 'wplab-albedo-core-plugin' ) 				=> 'black stroke',
				esc_html__( 'Grey Stroke', 'wplab-albedo-core-plugin' ) 				=> 'grey stroke',
				esc_html__( 'Red Stroke', 'wplab-albedo-core-plugin' ) 					=> 'red stroke',
				esc_html__( 'Orange Stroke', 'wplab-albedo-core-plugin' ) 			=> 'orange stroke',
				esc_html__( 'Green Stroke', 'wplab-albedo-core-plugin' ) 				=> 'green stroke',
				esc_html__( 'Turquoise Stroke', 'wplab-albedo-core-plugin' ) 		=> 'turquoise stroke',
				esc_html__( 'Yellow Stroke', 'wplab-albedo-core-plugin' ) 			=> 'yellow stroke',
				esc_html__( 'Purple Stroke', 'wplab-albedo-core-plugin' ) 			=> 'purple stroke',
				esc_html__( 'Dark Purple Stroke', 'wplab-albedo-core-plugin' ) 	=> 'dark-purple stroke',
				esc_html__( 'Red Gradient', 'wplab-albedo-core-plugin' ) 				=> 'red-gradient gradient-button',
				esc_html__( 'Violet Gradient', 'wplab-albedo-core-plugin' ) 		=> 'violet-gradient gradient-button',
				esc_html__( 'Turquoise Gradient', 'wplab-albedo-core-plugin' ) 	=> 'turquoise-gradient gradient-button',
				esc_html__( 'Blue Gradient', 'wplab-albedo-core-plugin' ) 			=> 'blue-gradient gradient-button',
				esc_html__( 'Grey Gradient', 'wplab-albedo-core-plugin' ) 			=> 'grey-gradient gradient-button',
				esc_html__( 'Orange Gradient', 'wplab-albedo-core-plugin' ) 		=> 'orange-gradient gradient-button',
				esc_html__( 'Green Gradient', 'wplab-albedo-core-plugin' ) 			=> 'green-gradient gradient-button',
				esc_html__( 'Purple Gradient', 'wplab-albedo-core-plugin' ) 		=> 'purple-gradient gradient-button',
			)
		);

	}

	/**
	 * Add styles
	 **/

	function add_front_styles() {

		if( ! class_exists( 'wplab_albedo_utils') ) {
			return false;
		}

		if( (is_page() || is_single() || is_singular()) && wplab_albedo_utils::is_vc() ) {
			global $post;
			if( has_shortcode( $post->post_content, 'rev_slider' ) || has_shortcode( $post->post_content, 'rev_slider_vc' ) ) {
				$variable_style = $this->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/plugins/revslider.less') );
				wp_enqueue_style( 'albedo-revslider', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );
			}
		}

	}

	function add_styles() {
		wp_enqueue_style( 'wplab-albedo-core-plugin', plugin_dir_url( __FILE__ ) . 'assets/style.css' , false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
	}

	/**
	 * Register additional Custom Post Types
	 **/
	function register_custom_post_types() {

		$disabled_post_types = array();

		if( $this->is_unyson ) {
			$disabled_post_types = fw_get_db_settings_option( 'disabled_custom_post_types' );
		}

		if( is_array( $disabled_post_types ) && !in_array( 'tables', $disabled_post_types ) ) {

			register_post_type( 'tables',
				array(
					'label' 						=> esc_html__( 'Tables / Pricing Tables', 'wplab-albedo-core-plugin'),
					'description' 			=> '',
					'public' 						=> false,
					'show_ui' 					=> true,
					'show_in_menu' 			=> true,
					'show_in_nav_menus' => true,
					'capability_type' 	=> 'post',
					'hierarchical' 			=> false,
					'supports' 					=> array( 'title', 'custom-fields' ),
					'rewrite' 					=> false,
					'has_archive' 			=> false,
					'query_var' 				=> false,
					'menu_position'   	=> 5,
					'capabilities' => array(
						'publish_posts' => 'edit_pages',
						'edit_posts' => 'edit_pages',
						'edit_others_posts' => 'edit_pages',
						'delete_posts' => 'edit_pages',
						'delete_others_posts' => 'edit_pages',
						'read_private_posts' => 'edit_pages',
						'edit_post' => 'edit_pages',
						'delete_post' => 'edit_pages',
						'read_post' => 'edit_pages',
					),
					'labels'					=> array(
						'name' 									=> esc_html__( 'Tables', 'wplab-albedo-core-plugin'),
						'singular_name' 				=> esc_html__( 'Table', 'wplab-albedo-core-plugin'),
						'menu_name' 						=> esc_html__( 'Tables', 'wplab-albedo-core-plugin'),
						'add_new' 							=> esc_html__( 'Add Table', 'wplab-albedo-core-plugin'),
						'add_new_item' 					=> esc_html__( 'Add New Table', 'wplab-albedo-core-plugin'),
						'all_items' 						=> esc_html__( 'All Tables', 'wplab-albedo-core-plugin'),
						'edit_item' 						=> esc_html__( 'Edit Table', 'wplab-albedo-core-plugin'),
						'new_item' 							=> esc_html__( 'New Table', 'wplab-albedo-core-plugin'),
						'view_item' 						=> esc_html__( 'View Table', 'wplab-albedo-core-plugin'),
						'search_items' 					=> esc_html__( 'Search Tables', 'wplab-albedo-core-plugin'),
						'not_found' 						=> esc_html__( 'No Tables Found', 'wplab-albedo-core-plugin'),
						'not_found_in_trash'		=> esc_html__( 'No Tables Found in Trash', 'wplab-albedo-core-plugin'),
						'parent_item_colon' 		=> esc_html__( 'Parent Table:', 'wplab-albedo-core-plugin') )
				)
			);

			remove_post_type_support( 'tables', 'thumbnail' );

		}

		if( is_array( $disabled_post_types ) && !in_array( 'benefits', $disabled_post_types ) ) {

			register_post_type( 'benefits',
				array(
					'label' 						=> esc_html__( 'Benefits', 'wplab-albedo-core-plugin'),
					'description' 			=> '',
					'public' 						=> true,
					'show_ui' 					=> true,
					'show_in_menu' 			=> true,
					'show_in_nav_menus' => true,
					'capability_type' 	=> 'post',
					'hierarchical' 			=> false,
					'supports' 					=> array( 'title', 'editor', 'excerpt', 'custom-fields' ),
					'rewrite' 					=> true,
					'has_archive' 			=> true,
					'query_var' 				=> true,
					'menu_position'   	=> 7,
					'capabilities' => array(
						'publish_posts' => 'edit_pages',
						'edit_posts' => 'edit_pages',
						'edit_others_posts' => 'edit_pages',
						'delete_posts' => 'edit_pages',
						'delete_others_posts' => 'edit_pages',
						'read_private_posts' => 'edit_pages',
						'edit_post' => 'edit_pages',
						'delete_post' => 'edit_pages',
						'read_post' => 'edit_pages',
					),
					'labels'					=> array(
						'name' 									=> esc_html__( 'Benefits', 'wplab-albedo-core-plugin'),
						'singular_name' 				=> esc_html__( 'Benefit', 'wplab-albedo-core-plugin'),
						'menu_name' 						=> esc_html__( 'Benefits', 'wplab-albedo-core-plugin'),
						'add_new' 							=> esc_html__( 'Add Benefit', 'wplab-albedo-core-plugin'),
						'add_new_item' 					=> esc_html__( 'Add New Benefit', 'wplab-albedo-core-plugin'),
						'all_items' 						=> esc_html__( 'All Benefits', 'wplab-albedo-core-plugin'),
						'edit_item' 						=> esc_html__( 'Edit Benefit', 'wplab-albedo-core-plugin'),
						'new_item' 							=> esc_html__( 'New Benefit', 'wplab-albedo-core-plugin'),
						'view_item' 						=> esc_html__( 'View Benefit', 'wplab-albedo-core-plugin'),
						'search_items' 					=> esc_html__( 'Search Benefits', 'wplab-albedo-core-plugin'),
						'not_found' 						=> esc_html__( 'No Benefits Found', 'wplab-albedo-core-plugin'),
						'not_found_in_trash'		=> esc_html__( 'No Benefits Found in Trash', 'wplab-albedo-core-plugin'),
						'parent_item_colon' 		=> esc_html__( 'Parent Benefit:', 'wplab-albedo-core-plugin') )
				)
			);

			register_taxonomy( 'benefits_category',
				'benefits',
				array(
					'hierarchical' 				=> true,
					'show_ui' 						=> true,
					'query_var' 					=> false,
					'show_in_nav_menus' 	=> false,
					'rewrite' 						=> false,
					'show_admin_column'   => true,
					'labels'              => array(
						'name'                => _x( 'Benefits Categories', 'taxonomy general name', 'wplab-albedo-core-plugin' ),
						'singular_name'       => _x( 'Benefits Category', 'taxonomy singular name', 'wplab-albedo-core-plugin' ),
						'search_items'        => esc_html__( 'Search in categories', 'wplab-albedo-core-plugin' ),
						'all_items'           => esc_html__( 'All Categories', 'wplab-albedo-core-plugin' ),
						'edit_item'           => esc_html__( 'Edit Category', 'wplab-albedo-core-plugin' ),
						'update_item'         => esc_html__( 'Update Category', 'wplab-albedo-core-plugin' ),
						'add_new_item'        => esc_html__( 'Add New Category', 'wplab-albedo-core-plugin' ),
						'new_item_name'       => esc_html__( 'New Category', 'wplab-albedo-core-plugin' ),
						'menu_name'           => esc_html__( 'Categories', 'wplab-albedo-core-plugin' )
					)
				)
			);

		}

		if( is_array( $disabled_post_types ) && !in_array( 'polls', $disabled_post_types ) ) {

			register_post_type( 'polls',
				array(
					'label' 						=> esc_html__( 'Polls', 'wplab-albedo-core-plugin'),
					'description' 			=> '',
					'public' 						=> false,
					'show_ui' 					=> true,
					'show_in_menu' 			=> true,
					'show_in_nav_menus' => false,
					'capability_type' 	=> 'post',
					'hierarchical' 			=> false,
					'supports' 					=> array( 'title', 'custom-fields' ),
					'rewrite' 					=> false,
					'has_archive' 			=> false,
					'query_var' 				=> false,
					'menu_position'   	=> 7,
					'capabilities' => array(
						'publish_posts' => 'edit_pages',
						'edit_posts' => 'edit_pages',
						'edit_others_posts' => 'edit_pages',
						'delete_posts' => 'edit_pages',
						'delete_others_posts' => 'edit_pages',
						'read_private_posts' => 'edit_pages',
						'edit_post' => 'edit_pages',
						'delete_post' => 'edit_pages',
						'read_post' => 'edit_pages',
					),
					'labels'					=> array(
						'name' 									=> esc_html__( 'Polls', 'wplab-albedo-core-plugin'),
						'singular_name' 				=> esc_html__( 'Poll', 'wplab-albedo-core-plugin'),
						'menu_name' 						=> esc_html__( 'Polls', 'wplab-albedo-core-plugin'),
						'add_new' 							=> esc_html__( 'Add Poll', 'wplab-albedo-core-plugin'),
						'add_new_item' 					=> esc_html__( 'Add New Poll', 'wplab-albedo-core-plugin'),
						'all_items' 						=> esc_html__( 'All Polls', 'wplab-albedo-core-plugin'),
						'edit_item' 						=> esc_html__( 'Edit Poll', 'wplab-albedo-core-plugin'),
						'new_item' 							=> esc_html__( 'New Poll', 'wplab-albedo-core-plugin'),
						'view_item' 						=> esc_html__( 'View Poll', 'wplab-albedo-core-plugin'),
						'search_items' 					=> esc_html__( 'Search Polls', 'wplab-albedo-core-plugin'),
						'not_found' 						=> esc_html__( 'No Polls Found', 'wplab-albedo-core-plugin'),
						'not_found_in_trash'		=> esc_html__( 'No Polls Found in Trash', 'wplab-albedo-core-plugin'),
						'parent_item_colon' 		=> esc_html__( 'Parent Poll:', 'wplab-albedo-core-plugin') )
				)
			);

		}

		if( is_array( $disabled_post_types ) && !in_array( 'media_slides', $disabled_post_types ) ) {

			register_post_type( 'media_slides',
				array(
					'label' 						=> esc_html__( 'Media Slides', 'wplab-albedo-core-plugin'),
					'description' 			=> '',
					'public' 						=> false,
					'show_ui' 					=> true,
					'show_in_menu' 			=> true,
					'show_in_nav_menus' => true,
					'capability_type' 	=> 'post',
					'hierarchical' 			=> false,
					'supports' 					=> array( 'title', 'editor', 'custom-fields', 'thumbnail' ),
					'rewrite' 					=> false,
					'has_archive' 			=> false,
					'query_var' 				=> false,
					'menu_position'   	=> 5,
					'capabilities' => array(
						'publish_posts' => 'edit_pages',
						'edit_posts' => 'edit_pages',
						'edit_others_posts' => 'edit_pages',
						'delete_posts' => 'edit_pages',
						'delete_others_posts' => 'edit_pages',
						'read_private_posts' => 'edit_pages',
						'edit_post' => 'edit_pages',
						'delete_post' => 'edit_pages',
						'read_post' => 'edit_pages',
					),
					'labels'					=> array(
						'name' 									=> esc_html__( 'Media Slides', 'wplab-albedo-core-plugin'),
						'singular_name' 				=> esc_html__( 'Slide', 'wplab-albedo-core-plugin'),
						'menu_name' 						=> esc_html__( 'Media Slides', 'wplab-albedo-core-plugin'),
						'add_new' 							=> esc_html__( 'Add Slide', 'wplab-albedo-core-plugin'),
						'add_new_item' 					=> esc_html__( 'Add New Slide', 'wplab-albedo-core-plugin'),
						'all_items' 						=> esc_html__( 'All Slides', 'wplab-albedo-core-plugin'),
						'edit_item' 						=> esc_html__( 'Edit Slide', 'wplab-albedo-core-plugin'),
						'new_item' 							=> esc_html__( 'New Slide', 'wplab-albedo-core-plugin'),
						'view_item' 						=> esc_html__( 'View Slide', 'wplab-albedo-core-plugin'),
						'search_items' 					=> esc_html__( 'Search Slides', 'wplab-albedo-core-plugin'),
						'not_found' 						=> esc_html__( 'No Slides Found', 'wplab-albedo-core-plugin'),
						'not_found_in_trash'		=> esc_html__( 'No Slides Found in Trash', 'wplab-albedo-core-plugin'),
						'parent_item_colon' 		=> esc_html__( 'Parent Slide:', 'wplab-albedo-core-plugin') )
				)
			);

			register_taxonomy( 'media_slides_category',
				'media_slides',
				array(
					'hierarchical' 				=> false,
					'show_ui' 						=> true,
					'query_var' 					=> false,
					'show_in_nav_menus' 	=> false,
					'rewrite' 						=> false,
					'show_admin_column'   => true,
					'labels'              => array(
						'name'                => _x( 'Slides Categories', 'taxonomy general name', 'wplab-albedo-core-plugin' ),
						'singular_name'       => _x( 'Slides Category', 'taxonomy singular name', 'wplab-albedo-core-plugin' ),
						'search_items'        => esc_html__( 'Search in categories', 'wplab-albedo-core-plugin' ),
						'all_items'           => esc_html__( 'All Categories', 'wplab-albedo-core-plugin' ),
						'edit_item'           => esc_html__( 'Edit Category', 'wplab-albedo-core-plugin' ),
						'update_item'         => esc_html__( 'Update Category', 'wplab-albedo-core-plugin' ),
						'add_new_item'        => esc_html__( 'Add New Category', 'wplab-albedo-core-plugin' ),
						'new_item_name'       => esc_html__( 'New Category', 'wplab-albedo-core-plugin' ),
						'menu_name'           => esc_html__( 'Categories', 'wplab-albedo-core-plugin' )
					)
				)
			);

		}

		if( is_array( $disabled_post_types ) && !in_array( 'team', $disabled_post_types ) ) {

			register_post_type( 'team',
				array(
					'label' 						=> esc_html__( 'Team Members', 'wplab-albedo-core-plugin'),
					'description' 			=> '',
					'public' 						=> false,
					'show_ui' 					=> true,
					'show_in_menu' 			=> true,
					'show_in_nav_menus' => true,
					'capability_type' 	=> 'post',
					'hierarchical' 			=> false,
					'supports' 					=> array( 'title', 'editor', 'custom-fields', 'thumbnail' ),
					'rewrite' 					=> false,
					'has_archive' 			=> false,
					'query_var' 				=> false,
					'menu_position'   	=> 5,
					'capabilities' => array(
						'publish_posts' => 'edit_pages',
						'edit_posts' => 'edit_pages',
						'edit_others_posts' => 'edit_pages',
						'delete_posts' => 'edit_pages',
						'delete_others_posts' => 'edit_pages',
						'read_private_posts' => 'edit_pages',
						'edit_post' => 'edit_pages',
						'delete_post' => 'edit_pages',
						'read_post' => 'edit_pages',
					),
					'labels'					=> array(
						'name' 									=> esc_html__( 'Team Members', 'wplab-albedo-core-plugin'),
						'singular_name' 				=> esc_html__( 'Team Member', 'wplab-albedo-core-plugin'),
						'menu_name' 						=> esc_html__( 'Team Members', 'wplab-albedo-core-plugin'),
						'add_new' 							=> esc_html__( 'Add Team Member', 'wplab-albedo-core-plugin'),
						'add_new_item' 					=> esc_html__( 'Add New Team Member', 'wplab-albedo-core-plugin'),
						'all_items' 						=> esc_html__( 'All Team Members', 'wplab-albedo-core-plugin'),
						'edit_item' 						=> esc_html__( 'Edit Team Member', 'wplab-albedo-core-plugin'),
						'new_item' 							=> esc_html__( 'New Team Member', 'wplab-albedo-core-plugin'),
						'view_item' 						=> esc_html__( 'View Team Member', 'wplab-albedo-core-plugin'),
						'search_items' 					=> esc_html__( 'Search Team Members', 'wplab-albedo-core-plugin'),
						'not_found' 						=> esc_html__( 'No Team Members Found', 'wplab-albedo-core-plugin'),
						'not_found_in_trash'		=> esc_html__( 'No Team Members Found in Trash', 'wplab-albedo-core-plugin'),
						'parent_item_colon' 		=> esc_html__( 'Parent Team Member:', 'wplab-albedo-core-plugin') )
				)
			);

			register_taxonomy( 'team_category',
				'team',
				array(
					'hierarchical' 				=> false,
					'show_ui' 						=> true,
					'query_var' 					=> false,
					'show_in_nav_menus' 	=> false,
					'rewrite' 						=> false,
					'show_admin_column'   => true,
					'labels'              => array(
						'name'                => _x( 'Team Members Categories', 'taxonomy general name', 'wplab-albedo-core-plugin' ),
						'singular_name'       => _x( 'Team Members Category', 'taxonomy singular name', 'wplab-albedo-core-plugin' ),
						'search_items'        => esc_html__( 'Search in categories', 'wplab-albedo-core-plugin' ),
						'all_items'           => esc_html__( 'All Categories', 'wplab-albedo-core-plugin' ),
						'edit_item'           => esc_html__( 'Edit Category', 'wplab-albedo-core-plugin' ),
						'update_item'         => esc_html__( 'Update Category', 'wplab-albedo-core-plugin' ),
						'add_new_item'        => esc_html__( 'Add New Category', 'wplab-albedo-core-plugin' ),
						'new_item_name'       => esc_html__( 'New Category', 'wplab-albedo-core-plugin' ),
						'menu_name'           => esc_html__( 'Categories', 'wplab-albedo-core-plugin' )
					)
				)
			);

		}

		if( is_array( $disabled_post_types ) && !in_array( 'testimonials', $disabled_post_types ) ) {

			register_post_type( 'testimonials',
				array(
					'label' 						=> esc_html__( 'Testimonials', 'wplab-albedo-core-plugin'),
					'description' 			=> '',
					'public' 						=> false,
					'show_ui' 					=> true,
					'show_in_menu' 			=> true,
					'show_in_nav_menus' => true,
					'capability_type' 	=> 'post',
					'hierarchical' 			=> false,
					'supports' 					=> array( 'title', 'editor', 'custom-fields', 'thumbnail' ),
					'rewrite' 					=> false,
					'has_archive' 			=> false,
					'query_var' 				=> false,
					'menu_position'   	=> 5,
					'capabilities' => array(
						'publish_posts' => 'edit_pages',
						'edit_posts' => 'edit_pages',
						'edit_others_posts' => 'edit_pages',
						'delete_posts' => 'edit_pages',
						'delete_others_posts' => 'edit_pages',
						'read_private_posts' => 'edit_pages',
						'edit_post' => 'edit_pages',
						'delete_post' => 'edit_pages',
						'read_post' => 'edit_pages',
					),
					'labels'					=> array(
						'name' 									=> esc_html__( 'Testimonials', 'wplab-albedo-core-plugin'),
						'singular_name' 				=> esc_html__( 'Testimonial', 'wplab-albedo-core-plugin'),
						'menu_name' 						=> esc_html__( 'Testimonials', 'wplab-albedo-core-plugin'),
						'add_new' 							=> esc_html__( 'Add Testimonial', 'wplab-albedo-core-plugin'),
						'add_new_item' 					=> esc_html__( 'Add New Testimonial', 'wplab-albedo-core-plugin'),
						'all_items' 						=> esc_html__( 'All Testimonials', 'wplab-albedo-core-plugin'),
						'edit_item' 						=> esc_html__( 'Edit Testimonial', 'wplab-albedo-core-plugin'),
						'new_item' 							=> esc_html__( 'New Testimonial', 'wplab-albedo-core-plugin'),
						'view_item' 						=> esc_html__( 'View Testimonial', 'wplab-albedo-core-plugin'),
						'search_items' 					=> esc_html__( 'Search Testimonials', 'wplab-albedo-core-plugin'),
						'not_found' 						=> esc_html__( 'No Testimonials Found', 'wplab-albedo-core-plugin'),
						'not_found_in_trash'		=> esc_html__( 'No Testimonials Found in Trash', 'wplab-albedo-core-plugin'),
						'parent_item_colon' 		=> esc_html__( 'Parent Testimonial:', 'wplab-albedo-core-plugin') )
				)
			);

			register_taxonomy( 'testimonials_category',
				'testimonials',
				array(
					'hierarchical' 				=> false,
					'show_ui' 						=> true,
					'query_var' 					=> false,
					'show_in_nav_menus' 	=> false,
					'rewrite' 						=> false,
					'show_admin_column'   => true,
					'labels'              => array(
						'name'                => _x( 'Testimonials Categories', 'taxonomy general name', 'wplab-albedo-core-plugin' ),
						'singular_name'       => _x( 'Testimonials Category', 'taxonomy singular name', 'wplab-albedo-core-plugin' ),
						'search_items'        => esc_html__( 'Search in categories', 'wplab-albedo-core-plugin' ),
						'all_items'           => esc_html__( 'All Categories', 'wplab-albedo-core-plugin' ),
						'edit_item'           => esc_html__( 'Edit Category', 'wplab-albedo-core-plugin' ),
						'update_item'         => esc_html__( 'Update Category', 'wplab-albedo-core-plugin' ),
						'add_new_item'        => esc_html__( 'Add New Category', 'wplab-albedo-core-plugin' ),
						'new_item_name'       => esc_html__( 'New Category', 'wplab-albedo-core-plugin' ),
						'menu_name'           => esc_html__( 'Categories', 'wplab-albedo-core-plugin' )
					)
				)
			);

		}

		if( is_array( $disabled_post_types ) && !in_array( 'timeline_events', $disabled_post_types ) ) {

			register_post_type( 'timeline_events',
				array(
					'label' 						=> esc_html__( 'Timeline Events', 'wplab-albedo-core-plugin'),
					'description' 			=> '',
					'public' 						=> false,
					'show_ui' 					=> true,
					'show_in_menu' 			=> true,
					'show_in_nav_menus' => true,
					'capability_type' 	=> 'post',
					'hierarchical' 			=> false,
					'supports' 					=> array( 'title', 'editor', 'custom-fields' ),
					'rewrite' 					=> false,
					'has_archive' 			=> false,
					'query_var' 				=> false,
					'menu_position'   	=> 5,
					'capabilities' => array(
						'publish_posts' => 'edit_pages',
						'edit_posts' => 'edit_pages',
						'edit_others_posts' => 'edit_pages',
						'delete_posts' => 'edit_pages',
						'delete_others_posts' => 'edit_pages',
						'read_private_posts' => 'edit_pages',
						'edit_post' => 'edit_pages',
						'delete_post' => 'edit_pages',
						'read_post' => 'edit_pages',
					),
					'labels'					=> array(
						'name' 									=> esc_html__( 'Timeline Events', 'wplab-albedo-core-plugin'),
						'singular_name' 				=> esc_html__( 'Event', 'wplab-albedo-core-plugin'),
						'menu_name' 						=> esc_html__( 'Timeline Events', 'wplab-albedo-core-plugin'),
						'add_new' 							=> esc_html__( 'Add Event', 'wplab-albedo-core-plugin'),
						'add_new_item' 					=> esc_html__( 'Add New Event', 'wplab-albedo-core-plugin'),
						'all_items' 						=> esc_html__( 'All Events', 'wplab-albedo-core-plugin'),
						'edit_item' 						=> esc_html__( 'Edit Event', 'wplab-albedo-core-plugin'),
						'new_item' 							=> esc_html__( 'New Event', 'wplab-albedo-core-plugin'),
						'view_item' 						=> esc_html__( 'View Event', 'wplab-albedo-core-plugin'),
						'search_items' 					=> esc_html__( 'Search Events', 'wplab-albedo-core-plugin'),
						'not_found' 						=> esc_html__( 'No Events Found', 'wplab-albedo-core-plugin'),
						'not_found_in_trash'		=> esc_html__( 'No Events Found in Trash', 'wplab-albedo-core-plugin'),
						'parent_item_colon' 		=> esc_html__( 'Parent Event:', 'wplab-albedo-core-plugin') )
				)
			);

			register_taxonomy( 'timeline_events_category',
				'timeline_events',
				array(
					'hierarchical' 				=> false,
					'show_ui' 						=> true,
					'query_var' 					=> false,
					'show_in_nav_menus' 	=> false,
					'rewrite' 						=> false,
					'show_admin_column'   => true,
					'labels'              => array(
						'name'                => _x( 'Events Categories', 'taxonomy general name', 'wplab-albedo-core-plugin' ),
						'singular_name'       => _x( 'Events Category', 'taxonomy singular name', 'wplab-albedo-core-plugin' ),
						'search_items'        => esc_html__( 'Search in categories', 'wplab-albedo-core-plugin' ),
						'all_items'           => esc_html__( 'All Categories', 'wplab-albedo-core-plugin' ),
						'edit_item'           => esc_html__( 'Edit Category', 'wplab-albedo-core-plugin' ),
						'update_item'         => esc_html__( 'Update Category', 'wplab-albedo-core-plugin' ),
						'add_new_item'        => esc_html__( 'Add New Category', 'wplab-albedo-core-plugin' ),
						'new_item_name'       => esc_html__( 'New Category', 'wplab-albedo-core-plugin' ),
						'menu_name'           => esc_html__( 'Categories', 'wplab-albedo-core-plugin' )
					)
				)
			);

		}

	}

	/**
	 * Add Page Builder from Unyson Plugin
	 **/
	function filter_unyson( $post_types ) {
		$post_types['benefits'] = esc_html__( 'Benefits', 'wplab-albedo-core-plugin' );
		return $post_types;
	}

	/**
	 * Setup Visual Composer
	 **/
	function setup_vc() {

		if( ! $this->is_vc ) {
			return false;
		}

		// Set Visual Composer as a part of theme
		if( $this->is_unyson ) {

			if( ! filter_var( fw_get_db_settings_option( 'vc_standalone' ) ) ) {
				vc_set_as_theme();
			}

		} else {
			vc_set_as_theme();
		}

		// Remove help pointers
		remove_action( 'admin_enqueue_scripts', 'vc_pointer_load' );

		// Change default VC templates directory
		vc_set_shortcodes_templates_dir( plugin_dir_path( __FILE__ ) . '/vc_templates' );

	}

	/**
	 * Create custom parameters for Visual Composer
	**/
	function register_custom_params() {

		// margins box
		vc_add_shortcode_param( 'albedo_sides_box', array( $this, 'add_vc_param_margins_box' ), plugin_dir_url( __FILE__ ) . '/assets/albedo_sides_box.js' );

	}

	/**
	 * Add custom "Margins Box" option type
	 **/
	function add_vc_param_margins_box( $settings, $value ) {

		$val = explode( '|', $value );

		$top = isset( $val[0] ) ? esc_attr( $val[0] ) : '';
		$right = isset( $val[1] ) ? esc_attr( $val[1] ) : '';
		$bottom = isset( $val[2] ) ? esc_attr( $val[2] ) : '';
		$left = isset( $val[3] ) ? esc_attr( $val[3] ) : '';

		return '<div class="wplab-albedo-vc-sides-box">' .

		'<input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput albedo-sides-box-value ' .
		esc_attr( $settings['param_name'] ) . ' ' .
		esc_attr( $settings['type'] ) . '_field" type="hidden" value="' . $value . '" />' .

		'<input placeholder="' . esc_html__('Top', 'wplab-albedo-core-plugin') . '" name="albedo_sides_box[]" class="albedo-sides-box" ' .
		'type="text" value="' . $top . '" />' .

		'<input placeholder="' . esc_html__('Right', 'wplab-albedo-core-plugin') . '" name="albedo_sides_box[]" class="albedo-sides-box" ' .
		'type="text" value="' . $right . '" />' .

		'<input placeholder="' . esc_html__('Bottom', 'wplab-albedo-core-plugin') . '" name="albedo_sides_box[]" class="albedo-sides-box" ' .
		'type="text" value="' . $bottom . '" />' .

		'<input placeholder="' . esc_html__('Left', 'wplab-albedo-core-plugin') . '" name="albedo_sides_box[]" class="albedo-sides-box" ' .
		'type="text" value="' . $left . '" />' .

		'</div>';
	}

	/**
	 * Register Visual Composer Shortcodes
	 **/
	function register_vc_shortcodes() {

		// do not load shortcoes if Albedo theme is not active, since these shortcodes use a big part of code from thos theme
		if( ! class_exists('wplab_albedo_core_controller') || ! $this->is_vc ) {
			return false;
		}

		$disabled_shortcodes = array();

		if( $this->is_unyson ) {
			$disabled_shortcodes = fw_get_db_settings_option( 'disabled_shortcodes' );
		}

		$shortcodes = glob( plugin_dir_path( __FILE__ ) . '/shortcodes/*' , GLOB_ONLYDIR);

		foreach( $shortcodes as $shortcode ) {
			$shortcode_name = str_replace( '-', '_', basename( $shortcode ));

			if( in_array( $shortcode_name, $shortcodes ) ) {
				continue;
			}

			$main_init_file = $shortcode . '/shortcode.php';
			$overridden_init_file = get_stylesheet_directory() . '/albedo_vc_shortcodes/' . $shortcode . '/shortcode.php';

			if( file_exists( $overridden_init_file ) ) {
				require_once $overridden_init_file;
			} else if( file_exists( $main_init_file ) ) {
				require_once $main_init_file;
			}

		}


	}

	/**
		* Add SSL support to Visual Composer
	**/
	function change_frontend_editor_iframe_url( $url ) {
		return is_ssl() ? str_replace("http://", "https://", $url) : $url;
	}


	public function lessify( $stylesheet_uri, $cache_key = null ) {

		if( !class_exists('WPLessPlugin') ) {
			return;
		}

		static $wp_less_uri_cache;
		$cache_key = 'wp-less-' . ( is_null( $cache_key ) ? md5($stylesheet_uri) : $cache_key);
		if (is_null($wp_less_uri_cache)) {
			$wp_less_uri_cache = array();
		}

		if (isset($wp_less_uri_cache[$cache_key])) {
			return $wp_less_uri_cache[$cache_key];
		}

		wp_register_style($cache_key, $stylesheet_uri);
		$stylesheet = WPLessPlugin::getInstance()->processStylesheet($cache_key);
		wp_deregister_style($cache_key);
		$wp_less_uri_cache[$cache_key] = $stylesheet->getTargetUri();
		unset($stylesheet);
		return $wp_less_uri_cache[$cache_key];

	}

}

$wplab_albedo_core_plugin = new wplab_albedo_core_plugin();
