<?php
  global $wplab_albedo_core;
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

  $attributes = $classes = array();

	/** unique id **/
	$attributes[] = 'id="shortcode-' . esc_attr( $atts['el_id'] ) . '"';

  $terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'timeline_events',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'timeline_events_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

  /*
	if( is_rtl() ) {
		$atts['items'] = array_reverse( $atts['items'] );
	}
  */

	if( filter_var( $atts['is_sticky'], FILTER_VALIDATE_BOOLEAN ) ) {
		$classes[] = 'sticky';
	}

?>
<div <?php echo implode( ' ', $attributes ); ?> class="vertical-timeline <?php echo implode( ' ', $classes ); ?>">
	<div class="row">
		<div class="col-md-4 col-sm-4 col-xs-4 col col-events" data-scroll-offset="<?php echo absint( $atts['scroll_offset_top'] ); ?>">

			<div class="events">

        <?php $i=0; while ( $items->have_posts() ): $items->the_post(); $i++; ?>

          <?php $date = get_the_date( $atts['date_format'], get_the_ID() );  ?>
          <a href="javascript:;" class="event <?php if( $i == 1 ): ?>selected<?php endif; ?>">
            <span class="date"><span class="date-desktop"><?php echo $date ; ?></span><span class="date-mobile"><?php echo get_the_date( $atts['date_format_mobile'], get_the_ID() ); ?></span></span>
            <span class="title"><?php the_title(); ?></span>
            <span class="dot"></span>
          </a>

        <?php endwhile; wp_reset_postdata(); ?>

				<span class="filling-line"></span>
			</div>

		</div>
		<div class="col-md-1 col col-space"></div>
		<div class="col-md-7 col-sm-7 col-xs-7 col col-content">
			<div class="events-text">

        <?php $i=0; while ( $items->have_posts() ): $items->the_post(); $i++; ?>

        <div class="item-content fadeIn <?php if( $i == 1 ): ?> selected<?php endif; ?>">
          <?php
            $title = get_the_title();
            if( $title <> ''):
          ?>
          <h2><?php echo $title; ?></h2>
        <?php endif; the_content(); ?>
        </div>

        <?php endwhile; wp_reset_postdata(); ?>

			</div>
		</div>

	</div>
</div>
