<?php
	global $wplab_albedo_core;
	$id = esc_attr( $atts['el_id'] );

	/** unique id **/
	$attributes[] = 'id="shortcode-' . $id . '"';

	$classes[] = esc_attr( $atts['effect'] );
	$classes[] = 'cols-' . absint( $atts['cols'] );

	$terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'testimonials',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'testimonials_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>

<div class="shortcode-testimonials-grid <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>

	<ul id="testimonials-grid-<?php echo $id; ?>" class="grid">
		<?php
			while ( $items->have_posts() ): $items->the_post();
			$text = get_the_content();
			$author = fw_get_db_post_option( get_the_ID(), 'author' );
			$position = fw_get_db_post_option( get_the_ID(), 'position' );
			$photo = get_the_post_thumbnail_url( get_the_ID(), 'full');

		  $animated_on_hover = filter_var( $atts['animate_on_hover'], FILTER_VALIDATE_BOOLEAN );
			$hover_animation = $animated_on_hover ? $atts['animate_on_hover_effect'] : '';
		?>
		<li>
		  <div class="item-content">

		    <?php if( $photo <> '' ): ?>
		    <div class="photo<?php if( $animated_on_hover ): ?> animate-on-hover<?php endif; ?>" data-hover-animation="<?php echo esc_attr($hover_animation); ?>">
		      <?php echo wplab_albedo_media::image( $photo, 100, 100, true, true, $photo ); ?>
		    </div>
		    <?php endif; ?>

		    <?php if( $text <> '' ): ?>
		    <div class="text">
		      <?php echo wp_kses_post( $text ); ?>
		    </div>
		    <?php endif; ?>

		    <div class="about-author">
		      <?php if( $author <> '' ): ?>
		      <div class="author">
		        <?php echo wp_kses_post( $author ); ?>
		      </div>
		      <?php endif; ?>
		      <?php if( $position <> '' ): ?>
		      <div class="position">
		        <?php echo wp_kses_post( $position ); ?>
		      </div>
		      <?php endif; ?>
		    </div>

		  </div>
		</li>
		<?php endwhile; wp_reset_postdata(); ?>
	</ul>

</div>
