<?php
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
?>
<div class="swiper-slide">
  <div class="item-content">

    <?php
      $text = $item['free_text'];
      $name = $item['name'];
      $position = $item['position'];
      $photo = $item['photo'] <> '' ? wp_get_attachment_url( $item['photo'] ) : '';
    ?>

    <div class="photo">
      <?php if( $photo <> '' ): ?>
        <?php echo wplab_albedo_media::image( $photo, 440, 330, true, true, $photo ); ?>
      <?php endif; ?>
    </div>

    <div class="text-content">

      <div class="text-inside">
        <?php if( $name <> '' ): ?>
        <div class="name">
          <?php echo wp_kses_post( $name ); ?>
        </div>
        <?php endif; ?>

        <?php if( $position <> '' ): ?>
        <div class="position">
          <?php echo wp_kses_post( $position ); ?>
        </div>
        <?php endif; ?>

        <div class="toggle-text">
          <?php if( $text <> '' ): ?>
          <div class="text">
            <?php echo wp_kses_post( $text ); ?>
          </div>
          <?php endif; ?>

          <div class="social">
          <?php wplab_albedo_front::print_fa_icons( $item ); ?>
          </div>
        </div>
      </div>

    </div>

  </div>
</div>
