<?php
  if( trim( $atts['address'] ) == '' ) {
    return;
  }
  global $wplab_albedo_core_plugin;
?>
<div id="google-map-id-<?php echo $atts['el_id']; ?>" class="albedo-google-map<?php if( filter_var( $atts['display_shadow'], FILTER_VALIDATE_BOOLEAN ) ): ?> shadow-color-grey<?php endif; ?>" style="width: 100%; height: <?php echo esc_attr( $atts['map_height'] ); ?>px;">
  <div style="width: 100%; height: 100%; border: 2px solid #eaeaea; background-image: url(<?php echo $wplab_albedo_core_plugin->plugin_uri; ?>/assets/shortcode_icons/map.png); background-repeat: no-repeat; background-position: center center;"></div>
</div>

<script src="//maps.googleapis.com/maps/api/js<?php if( $atts['api_key'] <> ''): ?>?key=<?php echo $atts['api_key']; ?><?php endif; ?>"></script>

<script type="text/javascript">

var geocoder = new google.maps.Geocoder();

var latlong;

var googleMapOptions = {
  zoom: <?php echo absint( $atts['zoom'] ); ?>,
  center: new google.maps.LatLng(0, 0),
  mapTypeId: google.maps.MapTypeId.<?php echo strtoupper( $atts['map_type'] ); ?>,
  panControl: false,
  zoomControl: false,
  scrollwheel: <?php echo filter_var( $atts['disable_scrolling'], FILTER_VALIDATE_BOOLEAN ) ? 'true' : 'false'; ?>,
  disableDoubleClickZoom: true,
  disableDefaultUI: true,
  draggable: true,
  scaleControl: false
};

var map = new google.maps.Map( document.getElementById('google-map-id-<?php echo $atts['el_id']; ?>'), googleMapOptions );

geocoder.geocode( { 'address': '<?php echo esc_html( $atts['address'] ); ?>'}, function(results, status) {
  if (status == google.maps.GeocoderStatus.OK) {
    latlong = results[0].geometry.location;

    var marker = new google.maps.Marker({
      position: latlong,
      map: map<?php if( $atts['pin_icon'] <> '' ): ?>,
      icon: '<?php echo wp_get_attachment_url( $atts['pin_icon'] ); ?>'<?php endif; ?>
    });

    map.setCenter( latlong );

  }
});

</script>
