<?php

	$cols = absint( $atts['cols'] );
	$column = 12/$cols;

  $animated = filter_var( $atts['animate_on_display'], FILTER_VALIDATE_BOOLEAN );
  $animation = $animated ? $atts['animate_on_display_effect'] : '';
  $animation_step = $animated ? $atts['animate_on_display_step'] : '';

  $animated_on_hover = filter_var( $atts['animate_on_hover'], FILTER_VALIDATE_BOOLEAN );
  $hover_animation = $animated_on_hover ? $atts['animate_on_hover_effect'] : '';

	$style = $atts['style'];
	$accent = $style == 'colorful' ? '-' . $atts['accent_color'] : '';

  $terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'benefits',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'benefits_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>
<div <?php echo implode( ' ', $attributes ); ?> class="shortcode-benefits-modern style-<?php echo esc_attr( $style ); ?> items-accent<?php echo esc_attr( $accent ); ?>" id="shortcode-<?php echo esc_attr( $atts['el_id'] ); ?>">

	<?php $counter = 0; while ( $items->have_posts() ): $items->the_post(); ?>

		<?php if( $counter % $cols == 0 ): ?>
		<div class="row">
		<?php endif; $counter++; ?>

    <?php
  		$icon_src = fw_get_db_post_option( get_the_ID(), 'icon' );
  		$icon_type = $icon_src['type'];
  		$no_icon = ($icon_type == 'icon-font' && empty( $icon_src['pack-name'] ) ) || ($icon_type == 'custom-upload' && empty( $icon_src['url'] ) );
  		$link = fw_get_db_post_option( get_the_ID(), 'link' );
  		$title = get_the_title();
  		$text = get_the_excerpt();
  	?>

		<div class="item col-md-<?php echo $column; ?> <?php echo $no_icon ? 'no-icon' : ''; ?> <?php if( $animated ): ?>wow <?php echo esc_attr( $animation ); endif; ?>" <?php if( $animated ): ?>data-wow-delay="<?php echo esc_attr( $animation_step * $counter / 2 ); ?>s"<?php endif; ?>>
			<div class="item-inside">

					<div class="line"></div>

          <?php if( $icon_type == 'icon-font' ): wp_enqueue_style( 'font-awesome' ); ?>

    			<div class="icon<?php if( $animated_on_hover ): ?> animate-on-hover<?php endif; ?>" data-hover-animation="<?php echo esc_attr($hover_animation); ?>">
    			  <i class="<?php echo esc_attr( $icon_src['icon-class'] ); ?>"></i>
    			</div>

    		  <?php elseif( $icon_type == 'custom-upload' ): ?>

    			<div class="icon<?php if( $animated_on_hover ): ?> animate-on-hover<?php endif; ?>" data-hover-animation="<?php echo esc_attr($hover_animation); ?>">
    			  <?php wplab_albedo_media::image_src( $icon_src['attachment-id'] ); ?>
    			</div>

    			<?php endif; ?>

					<div class="benefit-text">
            <?php if( $link <> '' ): ?>
    			  <a target="<?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN ) ): ?>_blank<?php endif; ?>" href="<?php echo esc_attr( $link ); ?>">
    			  <?php endif; ?>

    			  <?php if( $title <> '' ): ?>
    			  <h4><?php echo str_replace("<br /><br />", '<br />', nl2br( $title ) ); ?></h4>
    			  <?php endif; ?>

    			  <?php if( $link <> '' ): ?>
    			  </a>
    			  <?php endif; ?>

            <?php if( $text <> '' ): ?>
    			  <div class="desc"><?php echo wp_kses_post( $text ); ?></div>
    			  <?php endif; ?>

    			  <?php if( $link <> '' && filter_var( $atts['display_button'], FILTER_VALIDATE_BOOLEAN ) ): ?>
    			  <a target="<?php if( filter_var( $atts['link_target'], FILTER_VALIDATE_BOOLEAN ) ): ?>_blank<?php endif; ?>" href="<?php echo esc_attr( $link ); ?>" class="btn"></a>
    			  <?php endif; ?>

					</div>

			</div>
		</div>

	<?php if( $counter % $cols == 0 ): ?>
	</div>
	<?php endif; ?>

	<?php endwhile; wp_reset_postdata(); ?>

	<?php if( $counter%$cols != 0 ): ?>
	</div>
  <?php endif; ?>
</div>
