<?php

vc_map( array(
  'name' => esc_html__( 'Testimonials Grid', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_testimonials_grid',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/testimonials-grid.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/testimonials-grid/js/vc.js',
	'category' => esc_html__( 'Testimonials', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add testimonials grid', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All Testimonials', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Testimonials only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Testimonials except categories', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slides count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '10',
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'admin_label' => true,
      'value' => '',
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),

    /**
     * General tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'cols',
      'save_always' => true,
      'value' => array(
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Custom font family', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_font_family',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
			'type' => 'google_fonts',
			'param_name' => 'google_fonts',
			'value' => '',
      'dependency' => array(
  			'element' => 'custom_font_family',
  			'not_empty' => true,
  		),
			'settings' => array(
				'fields' => array(
					'font_family_description' => __( 'Select font family.', 'wplab-albedo-core-plugin' ),
					'font_style_description' => __( 'Select font styling.', 'wplab-albedo-core-plugin' ),
				),
			),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
		),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Animation tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Loading effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'save_always' => true,
      'value' => array(
        esc_html__('Fade', 'wplab-albedo-core-plugin') => 'effect-1',
        esc_html__('Move Up', 'wplab-albedo-core-plugin') => 'effect-2',
        esc_html__('Scale up', 'wplab-albedo-core-plugin') => 'effect-3',
        esc_html__('Fall perspective', 'wplab-albedo-core-plugin') => 'effect-4',
        esc_html__('Fly', 'wplab-albedo-core-plugin') => 'effect-5',
        esc_html__('Calendar', 'wplab-albedo-core-plugin') => 'effect-6',
        esc_html__('Helix', 'wplab-albedo-core-plugin') => 'effect-7',
        esc_html__('Flip', 'wplab-albedo-core-plugin') => 'effect-8',
      ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on hover', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_hover',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_hover_effect',
      'value' => $this->cfg['animations'],
      'save_always' => true,
      'dependency' => array(
  			'element' => 'animate_on_hover',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),

  )
));
