<?php

vc_map( array(
  'name' => esc_html__( 'Iconic Tabs', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_tabs_iconic',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/iconic-tabs.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/tabs-iconic/js/vc.js',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add iconic tabs', 'wplab-albedo-core-plugin' ),
  'as_parent' => array( 'only' => 'albedo_tabs_iconic_single' ),
  'content_element' => true,
  'is_container' => true,
  'show_settings_on_create' => true,
  'js_view' => 'VcColumnView',
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Responsive at', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'For example: 767. If screen size will be less than this number, tabs will be turned into small screen mode', 'wplab-albedo-core-plugin' ),
      'param_name' => 'responsive_break',
      'value' => '',
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on hover', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_hover',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_hover_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_hover',
  			'not_empty' => true,
  		),
    ),


  )
));

vc_map( array(
  'name' => esc_html__( 'Tab', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_tabs_iconic_single',
  'content_element' => true,
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/iconic-tabs.png',
  'as_child' => array( 'only' => 'albedo_tabs_iconic' ),
	'params' => array(

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'title',
      'admin_label' => true,
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Header', 'wplab-albedo-core-plugin' ),
      'param_name' => 'header',
      'admin_label' => true,
      'value' => '',
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Content', 'wplab-albedo-core-plugin' ),
      'param_name' => 'content',
      'value' => '',
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Tab icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_type',
      'save_always' => true,
      'value' => array(
        esc_html__('Choose an icon from Icon Library', 'wplab-albedo-core-plugin') => 'fontawesome',
        esc_html__('Upload custom Image icon', 'wplab-albedo-core-plugin') => 'custom',
      ),
    ),
    array(
      'type' => 'iconpicker',
      'heading' => esc_html__('Icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_font',
      'save_always' => true,
      'dependency' => array(
  			'element' => 'icon_type',
  			'value' => array( 'fontawesome' ),
  		),
      'settings' => array(
        'emptyIcon' => true,
        'type' => 'fontawesome',
      )
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Upload icon', 'wplab-albedo-core-plugin'),
      'param_name' => 'icon_image',
      'dependency' => array(
  			'element' => 'icon_type',
  			'value' => array( 'custom' ),
  		),
    ),
    array(
      'type' => 'attach_image',
      'heading' => esc_html__('Tab Image', 'wplab-albedo-core-plugin'),
      'param_name' => 'tab_image',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Image width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Value in pixels, for example: 400', 'wplab-albedo-core-plugin' ),
      'param_name' => 'image_width',
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Image height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Value in pixels, for example: 400', 'wplab-albedo-core-plugin' ),
      'param_name' => 'image_height',
      'value' => '',
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display a button', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_button',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_title',
      'save_always' => true,
      'value' => esc_html__( 'Read more', 'wplab-albedo-core-plugin' ),
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button URL', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_url',
      'value' => '',
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__( 'Button style', 'wplab-albedo-core-plugin' ),
      'param_name' => 'button_style',
      'save_always' => true,
      'value' => $this->cfg['button_styles'],
      'dependency' => array(
  			'element' => 'display_button',
  			'not_empty' => true,
  		),
    ),

  )
));
