<?php

  /**
    * Social Icons Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Social_Icons extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        wp_enqueue_style( 'wplab-albedo-social-icons', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/social_icons.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );
        $custom_css = '';

    		if( $atts['icon_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' a { color: ' . $atts['icon_color'] . '; }';
    		}

    		if( $atts['icon_hover_color'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' a:hover { color: ' . $atts['icon_hover_color'] . '; }';
    		}

    		if( $atts['font_size'] <> '' ) {
    			$custom_css .= ' #' . $shortcode_id . ' a { font-size: ' . $atts['font_size'] . 'px; }';
    		}

        $attributes[] = 'id="' . $shortcode_id . '"';
        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_social_icons.php';
        return ob_get_clean();

      }

    }
  }
