<?php

  /**
    * Services with photo Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Service_Photo extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        /** load static stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-services-modern', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/services_modern.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/services_modern_variable.less') );
        wp_enqueue_style( 'wplab-albedo-services-modern-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-services-modern', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/services-modern/static/js/scripts.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_service_photo.php';
        return ob_get_clean();

      }

    }
  }
