<?php

$custom_css = $custom_js = '';

/**
 * Enqueue scripts
**/

if( $atts['section_effects'] == 'video' ) {
  if( $atts['section_effect_video_parallax_speed'] <> '' ) {
    if( ! wp_is_mobile() ) {
      wp_enqueue_script( 'stellar');
    }
    wp_enqueue_script( 'wplab-albedo-section-stellar', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/stellar.js'), array('stellar'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
  }
  wp_enqueue_script( 'youtube-background' );
  wp_enqueue_script( 'wplab-albedo-section-ytbg', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/youtube_bg.js'), array('youtube-background'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
} elseif( $atts['section_effects'] == 'particleground' ) {
  wp_enqueue_script( 'particleground');
  wp_enqueue_script( 'wplab-albedo-section-particleground', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/particleground.js'), array('particleground'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
} elseif( $atts['section_effects'] == 'particles' ) {
  wp_enqueue_script( 'particles');
}
if( $atts['parallax_effects'] == 'mouse_parallax' ) {
  wp_enqueue_script( 'parallax');
  wp_enqueue_script( 'wplab-albedo-section-parallax', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/mouse_parallax.js'), array('parallax'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
} elseif( $atts['parallax_effects'] == 'parallax' ) {
  if( ! wp_is_mobile() ) {
    wp_enqueue_script( 'stellar');
  }
  wp_enqueue_script( 'wplab-albedo-section-stellar', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/stellar.js'), array('stellar'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
} elseif( $atts['parallax_effects'] == 'scroll_animation' ) {
  wp_enqueue_script( 'skrollr');
}

wp_enqueue_script( 'wplab-albedo-section', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/scripts' . $postfix . '.js'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );



/**
 * Custom CSS
**/

$inline_css = '';

if( $atts['bg_css_type'] == 'color' ) {
  if( $atts['background_color'] <> '' ) {
    $inline_css .= 'background-color: ' . $atts['background_color'] . '; ';
  }
}

if( $atts['overlay_effect'] <> '' || $atts['section_effects'] <> '' ) {
  $inline_css .= 'position: relative; ';
}

if( !in_array( $atts['parallax_effects'], array('parallax', 'mouse_parallax') ) ) {

   if( $atts['bg_css_type'] == 'gradient' ) {

     $gradient_start_color = esc_html( $atts['background_gradient_primary'] );
     $gradient_end_color = esc_html( $atts['background_gradient_secondary'] );
     $gradient_direction = esc_html( $atts['background_gradient_direction'] );

     if( $gradient_direction == 'top_bottom' ) {

       $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-linear-gradient(top, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(left top, left bottom, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-linear-gradient(top, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-linear-gradient(top, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-linear-gradient(top, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: linear-gradient(to bottom, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=0 ); ';

     } else if( $gradient_direction == 'left_right' ) {

       $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-linear-gradient(left, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(left top, right top, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-linear-gradient(left, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-linear-gradient(left, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-linear-gradient(left, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: linear-gradient(to right, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=1 ); ';

     } else if( $gradient_direction == 'top_left_bottom_right' ) {

       $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-linear-gradient(-45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(left top, right bottom, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-linear-gradient(-45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-linear-gradient(-45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-linear-gradient(-45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: linear-gradient(135deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=1 ); ';

     } else if( $gradient_direction == 'bottom_left_top_right' ) {

       $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(left bottom, right top, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: linear-gradient(45deg, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=1 ); ';

     } else if( $gradient_direction == 'radial' ) {

       $inline_css .= 'background: ' . $gradient_start_color . '; background: -moz-radial-gradient(center, ellipse cover, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -webkit-gradient(radial, center center, 0px, center center, 100%, color-stop(0%, ' . $gradient_start_color . '), color-stop(100%, ' . $gradient_end_color . ')); background: -webkit-radial-gradient(center, ellipse cover, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -o-radial-gradient(center, ellipse cover, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: -ms-radial-gradient(center, ellipse cover, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); background: radial-gradient(ellipse at center, ' . $gradient_start_color . ' 0%, ' . $gradient_end_color . ' 100%); filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="' . $gradient_start_color . '", endColorstr="' . $gradient_end_color . '", GradientType=1 ); ';

     }

  } elseif( $atts['bg_css_type'] == 'custom_gradient' ) {

    $gradient_style = esc_html( $atts['background_custom_gradient_style'] );

    $gradient_start_color = esc_html( $atts['background_gradient_primary'] );
    $gradient_end_color = esc_html( $atts['background_gradient_secondary'] );
    $gradient_start = absint( $atts['custom_background_start_pos'] );
    $gradient_end = absint( $atts['custom_background_end_pos'] );

    if( $gradient_style == 'radial' ) {

    $gradient_size = esc_html( $atts['background_custom_gradient_radial_size'] );
    $gradient_position = esc_html( $atts['background_custom_gradient_radial_pos'] );

    $inline_css .= '
background-image: -ms-radial-gradient(' . $gradient_position . ', ellipse ' . $gradient_size . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -moz-radial-gradient(' . $gradient_position . ', ellipse ' . $gradient_size . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -o-radial-gradient(' . $gradient_position . ', ellipse ' . $gradient_size . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -webkit-radial-gradient(' . $gradient_position . ', ellipse ' . $gradient_size . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
    ';

    } elseif( $gradient_style == 'linear' ) {

    $gradient_position = esc_html( $atts['background_custom_gradient_linear_pos'] );

      $inline_css .= '
background-image: -ms-linear-gradient(' . $gradient_position . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -moz-linear-gradient(' . $gradient_position . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -o-linear-gradient(' . $gradient_position . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
background-image: -webkit-linear-gradient(' . $gradient_position . ', ' . $gradient_start_color . ' ' . $gradient_start . '%, ' . $gradient_end_color . ' ' . $gradient_end . '%);
      ';

    }

  }

  if( ! filter_var( $atts['background_lazy'], FILTER_VALIDATE_BOOLEAN ) && $bg_image <> '' ) {
    $inline_css .= 'background-image: url(' . $bg_image . '); ';
  }

  if( $atts['background_repeat'] <> '' ) {
    $inline_css .= 'background-repeat: ' . $atts['background_repeat'] . '; ';
  }

  if( $atts['background_position'] <> '' ) {
    $inline_css .= 'background-position: ' . $atts['background_position'] . '; ';
  }

  if( $atts['custom_background_position'] <> '' ) {
    $inline_css .= 'background-position: ' . $atts['custom_background_position'] . '; ';
  }

  if( filter_var( $atts['background_cover'], FILTER_VALIDATE_BOOLEAN ) ) {
    $inline_css .= 'background-size: cover; ';
  }

  if( filter_var( $atts['background_fixed'], FILTER_VALIDATE_BOOLEAN ) ) {
    $inline_css .= 'background-attachment: fixed; ';
  }

}

if( $atts['parallax_effects'] == 'mouse_parallax' ) {

  $parallax_css = '';

  if( ! filter_var( $atts['background_lazy'], FILTER_VALIDATE_BOOLEAN ) && $bg_image <> '' ) {
    $parallax_css .= 'background-image: url(' . $bg_image . '); ';
  }

  if( $atts['background_repeat'] <> '' ) {
    $parallax_css .= 'background-repeat: ' . $atts['background_repeat'] . '; ';
  }

  if( $atts['background_position'] <> '' ) {
    $parallax_css .= 'background-position: ' . $atts['background_position'] . '; ';
  }

  if( filter_var( $atts['background_cover'], FILTER_VALIDATE_BOOLEAN ) ) {
    $parallax_css .= 'background-size: cover; ';
  }

  if( filter_var( $atts['background_fixed'], FILTER_VALIDATE_BOOLEAN ) ) {
    $parallax_css .= 'background-attachment: fixed; ';
  }

  $custom_css .= ' #' . $shortcode_id . ' .parallax-scene .layer-bg > div {' . $parallax_css . '}';

}
/**
 * Relative position
 **/
if( filter_var( $atts['is_relative'], FILTER_VALIDATE_BOOLEAN ) ) {
  $inline_css .= 'position: relative; ';
}
/**
 * Z-index
 **/
if( $atts['z_index'] <> '' ) {
  $inline_css .= 'z-index: ' . $atts['z_index'] . '; ';
  $outer_atts[] = 'id="outer-' . $atts['el_id'] . '"';
  $outer_atts[] = "data-custom-css='#outer-" . $atts['el_id'] . " { position: relative; z-index: " . $atts['z_index'] . "; }'";
}

/**
 * Custom margins, paddings and borders
 **/
if( $atts['margins'] <> '' ) {
  $sides_data = explode( '|', $atts['margins'] );
  $inline_css .= wplab_albedo_utils::get_styles( array(
    'top_margin' 			=> $sides_data[0],
    'right_margin' 		=> $sides_data[1],
    'bottom_margin' 	=> $sides_data[2],
    'left_margin' 		=> $sides_data[3],
  ), '' );

  // fix negative margin problems in Firefox and IE
  if( filter_var( $atts['is_relative'], FILTER_VALIDATE_BOOLEAN ) ) {
    $custom_css .= ' .ie #' . $shortcode_id . ' { display: inline-block; }  @-moz-document url-prefix() { #' . $shortcode_id . ' { display: inline-block; } }';
  }

}

if( $atts['paddings'] <> '' ) {
  $sides_data = explode( '|', $atts['paddings'] );
  $inline_css .= wplab_albedo_utils::get_styles( array(
    'top_padding' 		=> $sides_data[0],
    'right_padding' 	=> $sides_data[1],
    'bottom_padding' 	=> $sides_data[2],
    'left_padding' 		=> $sides_data[3],
  ), '' );

}

if( $atts['border_width'] <> '' ) {
  $sides_data = explode( '|', $atts['border_width'] );
  $inline_css .= wplab_albedo_utils::get_styles( array(
    'top_border' 			=> $sides_data[0],
    'right_border' 		=> $sides_data[1],
    'bottom_border' 	=> $sides_data[2],
    'left_border' 		=> $sides_data[3],
  ), '' );
}

if( $atts['border_color'] <> '' ) {
  $inline_css .= 'border-color: ' . $atts['border_color'] . ';';
}

if( $atts['border_style'] <> '' && $atts['border_style'] != 'none' ) {
  $inline_css .= 'border-style: ' . $atts['border_style'] . ';';
}

if( $atts['border_radius'] <> '' ) {
  $sides_data = explode( '|', $atts['border_radius'] );
  $inline_css .= wplab_albedo_utils::get_styles( array(
    'top_border_radius' 		=> $sides_data[0],
    'right_border_radius' 	=> $sides_data[1],
    'bottom_border_radius' 	=> $sides_data[2],
    'left_border_radius' 		=> $sides_data[3],
  ), '' );

}

if( filter_var( $atts['css_shadow'], FILTER_VALIDATE_BOOLEAN ) ) {
  $inline_css .= 'box-shadow: ' . $atts['css_shadow_position'] . ' ' . $atts['css_shadow_h_len'] . 'px ' . $atts['css_shadow_v_len'] . 'px ' . $atts['css_shadow_blur_radius'] . 'px ' . $atts['css_shadow_spread_radius'] . 'px ' . $atts['css_shadow_color'] . ';';
}

if( $inline_css <> '' ) {
  $custom_css .= ' #' . $shortcode_id . ' {' . $inline_css . '}';
}

/**
 * Responsiveness, medium screen
 **/
$inline_css = '';

  if( $atts['margins_medium'] <> '' ) {
    $sides_data = explode( '|', $atts['margins_medium'] );
    $inline_css .= wplab_albedo_utils::get_styles( array(
      'top_margin' 			=> $sides_data[0],
      'right_margin' 		=> $sides_data[1],
      'bottom_margin' 	=> $sides_data[2],
      'left_margin' 		=> $sides_data[3],
    ), '' );
  }

  if( $atts['paddings_medium'] <> '' ) {
    $sides_data = explode( '|', $atts['paddings_medium'] );
    $inline_css .= wplab_albedo_utils::get_styles( array(
      'top_padding' 		=> $sides_data[0],
      'right_padding' 	=> $sides_data[1],
      'bottom_padding' 	=> $sides_data[2],
      'left_padding' 		=> $sides_data[3],
    ), '' );
  }

if( $inline_css <> '' ) {
  $custom_css .= '@media screen and (max-width: 1199px) and (min-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
}

/**
 * Responsiveness, small screen
 **/
$inline_css = '';

  if( $atts['margins_mobile'] <> '' ) {
    $sides_data = explode( '|', $atts['margins_mobile'] );
    $inline_css .= wplab_albedo_utils::get_styles( array(
      'top_margin' 			=> $sides_data[0],
      'right_margin' 		=> $sides_data[1],
      'bottom_margin' 	=> $sides_data[2],
      'left_margin' 		=> $sides_data[3],
    ), '' );
  }

  if( $atts['paddings_mobile'] <> '' ) {
    $sides_data = explode( '|', $atts['paddings_mobile'] );
    $inline_css .= wplab_albedo_utils::get_styles( array(
      'top_padding' 		=> $sides_data[0],
      'right_padding' 	=> $sides_data[1],
      'bottom_padding' 	=> $sides_data[2],
      'left_padding' 		=> $sides_data[3],
    ), '' );
  }

if( $inline_css <> '' ) {
  $custom_css .= '@media screen and (max-width: 991px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
}

/**
 * Infinite motion effect
 **/
if( $atts['section_effects'] == 'infinite_motion' ) {
  $direction = $atts['section_effect_infinite_motion_direction'] == 'left' ? '' : '-';
  $speed = absint( $atts['section_effect_infinite_motion_speed'] );
  $bg_width = absint( $atts['section_effect_infinite_motion_texture_width'] );
  $custom_css .= ' @keyframes wplabInfiniteAnimation { from {background-position:0 0;} to {background-position: ' . $direction . $bg_width . 'px 0;} }';
  $custom_css .= ' #' . $shortcode_id . ' { background-repeat: repeat; background-position: 0 0; animation: ' . $speed . 's linear 0s normal none infinite wplabInfiniteAnimation;}';
}

/**
 * Particles effect
 **/
else if( $atts['section_effects'] == 'particles' ) {

  $particles_settings = array(
    'particles' => array(
      'number' => array(
        'value' => $atts['particles_number'],
        'density' => array(
          'enable' => filter_var( $atts['particles_density'], FILTER_VALIDATE_BOOLEAN ),
          'value_area' => $atts['particles_density_value']
        )
      ),
      'color' => array(
        'value' => $atts['particles_color'],
      ),
      'shape' => array(
        'type' => $atts['particles_shape_type'],
        'stroke' => array(
          'width' => $atts['particles_shape_stroke_width'],
          'color' => $atts['particles_shape_stroke_color']
        ),
        'polygon' => array(
          'nb_sides' => $atts['particles_polygon_sides']
        )
      ),
      'opacity' => array(
        'value' => $atts['particles_opacity'],
        'random' => filter_var( $atts['particles_opacity_random'], FILTER_VALIDATE_BOOLEAN ),
        'anim' => array(
          'enable' => filter_var( $atts['particles_animate_opacity'], FILTER_VALIDATE_BOOLEAN ),
          'speed' => $atts['particles_animate_opacity_speed'],
          'opacity_min' => $atts['particles_animate_opacity_min'],
          'sync' => filter_var( $atts['particles_animate_opacity_sync'], FILTER_VALIDATE_BOOLEAN ),
        )
      ),
      'size' => array(
        'value' => $atts['particles_size'],
        'random' => filter_var( $atts['particles_random_size'], FILTER_VALIDATE_BOOLEAN ),
        'anim' => array(
          'enable' => filter_var( $atts['particles_animate_size'], FILTER_VALIDATE_BOOLEAN ),
          'speed' => $atts['particles_animate_size_speed'],
          'size_min' => $atts['particles_animate_size_min_size'],
          'sync' => filter_var( $atts['particles_animate_size_sync'], FILTER_VALIDATE_BOOLEAN ),
        )
      ),
      'line_linked' => array(
        'enable' => filter_var( $atts['particles_enable_linked_lines'], FILTER_VALIDATE_BOOLEAN ),
        'distance' => $atts['particles_linked_lines_distance'],
        'color' => $atts['particles_linked_lines_color'],
        'opacity' => $atts['particles_linked_lines_opacity'],
        'width' => $atts['particles_linked_lines_width']
      ),
      'move' => array(
        'enable' => filter_var( $atts['particles_enable_move'], FILTER_VALIDATE_BOOLEAN ),
        'speed' => $atts['particles_move_speed'],
        'direction' => $atts['particles_move_direction'],
        'random' => filter_var( $atts['particles_move_random'], FILTER_VALIDATE_BOOLEAN ),
        'straight' => filter_var( $atts['particles_move_straight'], FILTER_VALIDATE_BOOLEAN ),
        'out_mode' => $atts['particles_move_out_mode'],
        'bounce' => false,
        'attract' => array(
          'enable' => false,
        )
      )
    ),
    'interactivity' => array(
      'detect_on' => 'canvas',
      'events' => array(
        'onhover' => array(
          'enable' => filter_var( $atts['particles_enable_hover_effect'], FILTER_VALIDATE_BOOLEAN ),
          'mode' => $atts['particles_hover_mode'],
        ),
        'onclick' => array(
          'enable' => filter_var( $atts['particles_enable_click_effect'], FILTER_VALIDATE_BOOLEAN ),
          'mode' => $atts['particles_click_effect_mode'],
        ),
        'resize' => true
      ),
      'modes' => array(
        'grab' => array(
          'distance' => $atts['particles_grab_distance'],
          'line_linked' => array(
            'opacity' => $atts['particles_grab_opacity']
          )
        ),
        'bubble' => array(
          'distance' => $atts['particles_bubble_distance'],
          'size' => $atts['particles_bubble_size'],
          'duration' => $atts['particles_bubble_duration'],
          'opacity' => $atts['particles_bubble_opacity'],
          'speed' => $atts['particles_bubble_speed'],
        ),
        'repulse' => array(
          'distance' => $atts['particles_repulse_distance'],
          'duration' => $atts['particles_repulse_duration']
        ),
        'push' => array(
          'particles_nb' => 4
        ),
        'remove' => array(
          'particles_nb' => 2
        )
      )
    ),
    'retina_detect' => true
  );

  $css_classes[] = 'albedo-particles-js';
  $attributes[] = 'data-particles-config=\'' . json_encode( $particles_settings ) . '\'';

  wp_enqueue_script( 'wplab-albedo-section-particles', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/particles.js'), array('particles'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
}

/**
 * Scroll animation
 **/
if( $atts['parallax_effects'] == 'scroll_animation' ) {
  $custom_css .= ' #' . $shortcode_id . ' { ' . $atts['scroll_animation_start_css'] . '}';
}

/**
 * Section overlay
 **/
if( $atts['overlay_effect'] <> '' ) {

  if( $atts['overlay_effect'] == 'solid' ) {

    if( $atts['background_overlay_image'] <> '' ) {
      $custom_css .= ' #' . $shortcode_id . ' .section-overlay-effect { background-image: url(' . wp_get_attachment_url( $atts['background_overlay_image'] ) . ')}';
    }

    $custom_css .= ' #' . $shortcode_id . ' .section-overlay-effect { background-color: ' . $atts['background_overlay_color'] . '; background-repeat: ' . $atts['background_overlay_image_repeat'] . '; background-position: ' . $atts['background_overlay_image_pos'] . '; }';

  }

}

$attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
