<?php

  /**
    * Simple Polls Shortcode
  **/

  vc_map( array(
    'name' => esc_html__( 'Simple Polls', 'wplab-albedo-core-plugin' ),
  	'base' => 'albedo_simple_polls',
    'icon' => $this->plugin_uri . '/assets/shortcode_icons/simple-polls.png',
    'front_enqueue_js' => $this->plugin_uri . '/shortcodes/polls/js/vc.js',
  	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
  	'description' => esc_html__( 'Add polls', 'wplab-albedo-core-plugin' ),
  	'params' => array(

      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Poll ID', 'wplab-albedo-core-plugin' ),
        'description' => esc_html__( 'Type here an ID of Poll to display it. Poll ID can be found near the Poll Title in the Polls posts list.', 'wplab-albedo-core-plugin' ),
        'param_name' => 'poll_id',
        'value' => '',
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__('Columns', 'wplab-albedo-core-plugin'),
        'param_name' => 'cols',
        'value' => array(
          '3' => '3',
          '2' => '2',
          '1' => '1',
        ),
      ),
      array(
        'type' => 'el_id',
        'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
        'param_name' => 'el_id',
        'settings' => array(
          'auto_generate' => true,
        ),
        'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
      ),

    )
  ));

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Simple_Polls extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

    		/** load stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-polls', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/polls.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/polls_variable.less') );
        wp_enqueue_style( 'wplab-albedo-polls-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'cookie' );
    		wp_enqueue_script( 'wplab-albedo-polls', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/polls/static/js/scripts' . $postfix . '.js'), array('jquery', 'cookie', 'md5'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
    		wp_localize_script( 'wplab-albedo-polls', 'wplabAlbedoPolls', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_simple_polls.php';
        return ob_get_clean();

      }

    }
  }
