<?php

  /**
    * Image Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Image extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
        $img_classes = $wrapper_classes = $img_attributes = $wrapper_attributes = array();

        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );
        $custom_css = '';

        /** include LightGallery library styles **/
    		wp_enqueue_style( 'lightgallery', get_template_directory_uri() . '/css/libs/lightgallery.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_style( 'lightgallery-transitions', get_template_directory_uri() . '/css/libs/lg-transitions.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_script( 'lightgallery');
    		//wp_enqueue_script( 'mousewheel');

    		/** include lightbox **/
    		$js_vars = array();

    		$js_vars['lightboxEffect'] = fw_get_db_customizer_option( 'lightbox_effect' );
    		$js_vars['lightboxEasing'] = fw_get_db_customizer_option( 'lightbox_easing' );
    		$js_vars['lightboxThumbs'] = filter_var( fw_get_db_customizer_option( 'lightbox_thumbnails' ), FILTER_VALIDATE_BOOLEAN );
    		$js_vars['lightboxCaptions'] = filter_var( fw_get_db_customizer_option( 'lightbox_captions' ), FILTER_VALIDATE_BOOLEAN );
    		$js_vars['lightboxFullscreen'] = filter_var( fw_get_db_customizer_option( 'lightbox_fullscreen' ), FILTER_VALIDATE_BOOLEAN );
    		$js_vars['lightboxZoom'] = filter_var( fw_get_db_customizer_option( 'lightbox_zoom' ), FILTER_VALIDATE_BOOLEAN );
    		$js_vars['lightboxDownload'] = filter_var( fw_get_db_customizer_option( 'lightbox_download' ), FILTER_VALIDATE_BOOLEAN );
    		$js_vars['lightboxAutoplay'] = filter_var( fw_get_db_customizer_option( 'lightbox_autoplay/enabled' ), FILTER_VALIDATE_BOOLEAN );
    		$js_vars['lightboxAutoplaySpeed'] = fw_get_db_customizer_option( 'lightbox_autoplay/yes/speed' );

    		if( $js_vars['lightboxThumbs'] == true ) {
    			wp_enqueue_script( 'lightgallery-thumb');
    		}
    		if( $js_vars['lightboxFullscreen'] == true ) {
    			wp_enqueue_script( 'lightgallery-fullscreen');
    		}
    		if( $js_vars['lightboxAutoplay'] == true ) {
    			wp_enqueue_script( 'lightgallery-autoplay');
    		}
    		if( $js_vars['lightboxZoom'] == true ) {
    			wp_enqueue_script( 'lightgallery-zoom');
    		}

    		wp_enqueue_script( 'wplab-albedo-media', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/media-image/static/js/scripts.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
    		wp_localize_script( 'wplab-albedo-media', 'wplabAlbedoMediaImage', $js_vars );

    		$inline_css = '';

    		/**
    		 * Custom margins, paddings and borders
    		 **/

    		if( $atts['margins'] <> '' ) {
          $sides_data = explode( '|', $atts['margins'] );
    			$inline_css .= wplab_albedo_utils::get_styles( array(
    				'top_margin' 			=> $sides_data[0],
    				'right_margin' 		=> $sides_data[1],
    				'bottom_margin' 	=> $sides_data[2],
    				'left_margin' 		=> $sides_data[3],
    			), '' );
    		}

    		if( $atts['paddings'] <> '' ) {
          $sides_data = explode( '|', $atts['paddings'] );
    			$inline_css .= wplab_albedo_utils::get_styles( array(
    				'top_padding' 		=> $sides_data[0],
    				'right_padding' 	=> $sides_data[1],
    				'bottom_padding' 	=> $sides_data[2],
    				'left_padding' 		=> $sides_data[3],
    			), '' );
    		}

    		if( $atts['border_width'] <> '' ) {
          $sides_data = explode( '|', $atts['border_width'] );
    			$border_css = wplab_albedo_utils::get_styles( array(
    				'top_border' 			=> $sides_data[0],
    				'right_border' 		=> $sides_data[1],
    				'bottom_border' 	=> $sides_data[2],
    				'left_border' 		=> $sides_data[3],
    			), '' );
    			$custom_css .= ' #' . $shortcode_id . ' img { ' . $border_css . '}';
    		}

    		if( $atts['border_color'] <> '' ) {
    			$border_css = 'border-color: ' . $atts['border_color'] . ';';
    			$custom_css .= ' #' . $shortcode_id . ' img { ' . $border_css . '}';
    		}

    		if( $atts['border_style'] <> '' ) {
    			$border_css = 'border-style: ' . $atts['border_style'] . ';';
    			$custom_css .= ' #' . $shortcode_id . ' img { ' . $border_css . '}';
    		}

    		if( $atts['border_radius'] <> '' ) {
    			$sides_data = explode( '|', $atts['border_radius'] );
    			$radius_styles = wplab_albedo_utils::get_styles( array(
    				'top_border_radius' 		=> $sides_data[0],
    				'right_border_radius' 	=> $sides_data[1],
    				'bottom_border_radius' 	=> $sides_data[2],
    				'left_border_radius' 		=> $sides_data[3],
    			), '' );

    			$custom_css .= ' #' . $shortcode_id . ' img { ' . $radius_styles . '}';

    		}

    		if( isset( $atts['css_shadow']['enabled'] ) && filter_var( $atts['css_shadow']['enabled'], FILTER_VALIDATE_BOOLEAN ) ) {
    			$shadow_type = isset( $atts['css_shadow']['yes']['shadow_type'] ) && $atts['css_shadow']['yes']['shadow_type'] == 'inside' ? 'inset' : '';
    			$inline_css .= 'box-shadow: ' . $shadow_type . ' ' . $atts['css_shadow']['yes']['shadow_horizontal_length'] . 'px ' . $atts['css_shadow']['yes']['shadow_vertical_length'] . 'px ' . $atts['css_shadow']['yes']['shadow_blur_radius'] . 'px ' . $atts['css_shadow']['yes']['shadow_spread_radius'] . 'px ' . $atts['css_shadow']['yes']['shadow_color'] . ';';
    		}

    		$custom_css .= ' #' . $shortcode_id . ' { ' . $inline_css . '}';

    		/**
    		 * Responsiveness, small screen
    		 **/
    		$inline_css = '';

    			if( $atts['margins_mobile'] <> '' ) {
            $sides_data = explode( '|', $atts['margins_mobile'] );
    				$inline_css .= wplab_albedo_utils::get_styles( array(
    					'top_margin' 			=> $sides_data[0],
    					'right_margin' 		=> $sides_data[1],
    					'bottom_margin' 	=> $sides_data[2],
    					'left_margin' 		=> $sides_data[3],
    				), '' );
    			}

    		if( $inline_css <> '' ) {
    			$custom_css .= '@media screen and (max-width: 767px) { #' . $shortcode_id . ' { ' . $inline_css . '} }';
    		}

        if( $custom_css <> '' ) {
          $wrapper_attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_image.php';
        return ob_get_clean();

      }
    }
  }
