<?php

  /**
    * Media Image Carousel Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Images_Carousel extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = $wrapper_classes = array();

        $id = $atts['el_id'];
        $shortcode_id = 'shortcode-' . esc_attr( $id );
        $attributes[] = 'id="' . $shortcode_id . '"';

        $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** include swiper carousel library styles **/
    		wp_enqueue_style( 'swiper', get_template_directory_uri() . '/css/libs/swiper.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_script( 'swiper');

    		/** include LightGallery library styles **/
    		wp_enqueue_style( 'lightgallery', get_template_directory_uri() . '/css/libs/lightgallery.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_style( 'lightgallery-transitions', get_template_directory_uri() . '/css/libs/lg-transitions.min.css', false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );
    		wp_enqueue_script( 'lightgallery');

    		/** load stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-image-carousel', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/image_carousel.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        global $wplab_albedo_core_plugin;
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/image_carousel_variable.less') );
        wp_enqueue_style( 'wplab-albedo-image-carousel-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/** include lightbox **/
    		/** shortcode script **/
    		$js_vars = array(
    			'lightboxEffect' => fw_get_db_customizer_option( 'lightbox_effect' ),
    			'lightboxEasing' => fw_get_db_customizer_option( 'lightbox_easing' ),
    			'lightboxThumbs' => filter_var( fw_get_db_customizer_option( 'lightbox_thumbnails' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxCaptions' => filter_var( fw_get_db_customizer_option( 'lightbox_captions' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxFullscreen' => filter_var( fw_get_db_customizer_option( 'lightbox_fullscreen' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxZoom' => filter_var( fw_get_db_customizer_option( 'lightbox_zoom' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxDownload' => filter_var( fw_get_db_customizer_option( 'lightbox_download' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxAutoplay' => filter_var( fw_get_db_customizer_option( 'lightbox_autoplay/enabled' ), FILTER_VALIDATE_BOOLEAN ),
    			'lightboxAutoplaySpeed' => absint( fw_get_db_customizer_option( 'lightbox_autoplay/yes/speed' ) ),
    		);

    		if( $js_vars['lightboxThumbs'] == true ) {
    			wp_enqueue_script( 'lightgallery-thumb');
    		}
    		if( $js_vars['lightboxFullscreen'] == true ) {
    			wp_enqueue_script( 'lightgallery-fullscreen');
    		}
    		if( $js_vars['lightboxAutoplay'] == true ) {
    			wp_enqueue_script( 'lightgallery-autoplay');
    		}
    		if( $js_vars['lightboxZoom'] == true ) {
    			wp_enqueue_script( 'lightgallery-zoom');
    		}

    		wp_enqueue_script( 'wplab-albedo-image-carousel', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/media-image-carousel/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
    		wp_localize_script( 'wplab-albedo-image-carousel', 'wplabAlbedoMediaImageCarousel', $js_vars );

    		if( is_numeric( $atts['border_radius'] ) ) {
    		 	$custom_css = ' #' . $shortcode_id . ' figure img { border-radius: ' . absint( $atts['border_radius'] ) . 'px; }';
          $attributes[] = 'data-custom-css="' . $custom_css . '"';
    		}

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_images_carousel.php';
        return ob_get_clean();

      }

    }
  }
