<?php

  /**
    * Button Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Albedo_Button extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . esc_attr( $atts['el_id'] );
        $custom_css = '';

        $css_classes[] = 'button';

        if( $atts['icon'] <> '' ) {
          wp_enqueue_style( 'font-awesome' );
        }

        if( $atts['custom_classes'] <> '' ) {
        	$css_classes[] = esc_attr( $atts['custom_classes'] );
        }

        /**
         * Link href
         **/
        if( isset( $atts['link'] ) && $atts['link'] <> '' ) {
        	$attributes[] = 'href="' . esc_attr( $atts['link'] ) . '"';
        }

        /**
         * Custom target
         **/
        if( $atts['target'] <> '' ) {
        	$attributes[] = 'target="' . $atts['target'] . '"';
        }

        /**
         * Animations
         **/
        if( filter_var( $atts['animation'], FILTER_VALIDATE_BOOLEAN ) ) {
        	$css_classes[] = 'wow';
        	$css_classes[] = $atts['animation_effect'];
        	$attributes[] = 'data-wow-delay="' . esc_attr( $atts['animation_delay'] ) . '"';
        }

        /**
         * Button style
         **/
        if( $atts['style'] <> '' ) {
        	$css_classes[] = 'style-' . esc_attr( $atts['style'] );
        }

        /**
         * Button size
         **/
        if( $atts['size'] <> '' ) {
        	$css_classes[] = 'size-' . esc_attr( $atts['size'] );
        }

        $inline_css = '';

        /** border radius **/
        if( $atts['border_radius'] <> '' ) {
          $inline_css .= 'border-radius: ' . $atts['border_radius'] . 'px;';
        }

        /** font weight **/
        if( $atts['font_weight'] <> '' ) {
          $inline_css .= 'font-weight: ' . $atts['font_weight'] . ';';
        }

        /** font variant **/
        if( $atts['font_variant'] <> '' ) {
          $inline_css .= 'font-variant: ' . $atts['font_variant'] . ';';
        }

        /** font style **/
        if( $atts['font_style'] <> '' ) {
          $inline_css .= 'font-style: ' . $atts['font_style'] . ';';
        }

        /** text transform **/
        if( $atts['text_transform'] <> '' ) {
          $inline_css .= 'text-transform: ' . $atts['text_transform'] . ';';
        }

        /** animation time **/
        if( $atts['animation_time'] <> '' ) {
          $inline_css .= 'transition: all ' . $atts['animation_time'] / 1000 . 's;';
        }

        /** margins **/
        if( $atts['margins'] <> '' ) {
          $sides_data = explode( '|', $atts['margins'] );
    			$inline_css .= wplab_albedo_utils::get_styles( array(
    				'top_margin' 		=> $sides_data[0],
    				'right_margin' 	=> $sides_data[1],
    				'bottom_margin' => $sides_data[2],
    				'left_margin' 	=> $sides_data[3],
    			), '' );
        }

        /** paddings **/
        if( $atts['paddings'] <> '' ) {
          $sides_data = explode( '|', $atts['paddings'] );
    			$inline_css .= wplab_albedo_utils::get_styles( array(
    				'top_padding' 		=> $sides_data[0],
    				'right_padding' 	=> $sides_data[1],
    				'bottom_padding' 	=> $sides_data[2],
    				'left_padding' 		=> $sides_data[3],
    			), '' );
        }

        $custom_css .= ' #' . $shortcode_id . ' { ' . $inline_css . '}';

        /**
         * Customize normal state
         **/
        $inline_css = '';
        if( filter_var( $atts['customize_normal_state'], FILTER_VALIDATE_BOOLEAN ) ) {

          /** text color **/
          if( $atts['normal_state_text_color'] <> '' ) {
            $inline_css .= 'color: ' . $atts['normal_state_text_color'] . ';';
          }

          /** background color **/
          if( $atts['normal_state_background_color'] <> '' ) {
            $inline_css .= 'background-color: ' . $atts['normal_state_background_color'] . ';';
          }

          /** border color **/
          if( $atts['normal_state_border_color'] <> '' ) {
            $inline_css .= 'border-color: ' . $atts['normal_state_border_color'] . ';';
          }

          /** border size **/
          if( $atts['normal_state_border_size'] <> '' ) {
            $inline_css .= 'border-width: ' . $atts['normal_state_border_size'] . 'px;';
          }

          /** shadow **/
          $inline_css .= 'box-shadow: ' . $atts['normal_state_shadow_h_length'] . 'px ' . $atts['normal_state_shadow_v_length'] . 'px ' . $atts['normal_state_shadow_blur_radius'] . 'px 0px ' . $atts['normal_state_shadow_color'] . ';';

          $custom_css .= ' #' . $shortcode_id . ' { ' . $inline_css . '}';
        }

        /**
         * Customize hover state
         **/
        $inline_css = '';
        if( filter_var( $atts['customize_hover_state'], FILTER_VALIDATE_BOOLEAN ) ) {

          /** text color **/
          if( $atts['hover_state_text_color'] <> '' ) {
            $inline_css .= 'color: ' . $atts['hover_state_text_color'] . ';';
          }

          /** background color **/
          if( $atts['hover_state_background_color'] <> '' ) {
            $inline_css .= 'background-color: ' . $atts['hover_state_background_color'] . ';';
          }

          /** border color **/
          if( $atts['hover_state_border_color'] <> '' ) {
            $inline_css .= 'border-color: ' . $atts['hover_state_border_color'] . ';';
          }

          /** border size **/
          if( $atts['hover_state_border_size'] <> '' ) {
            $inline_css .= 'border-width: ' . $atts['hover_state_border_size'] . 'px;';
          }

          /** shadow **/
          $inline_css .= 'box-shadow: ' . $atts['hover_state_shadow_h_length'] . 'px ' . $atts['hover_state_shadow_v_length'] . 'px ' . $atts['hover_state_shadow_blur_radius'] . 'px 0px ' . $atts['hover_state_shadow_color'] . ';';

          $custom_css .= ' #' . $shortcode_id . ':hover { ' . $inline_css . '}';
        }

        /**
         * Customize active state
         **/
        $inline_css = '';
        if( filter_var( $atts['customize_click_state'], FILTER_VALIDATE_BOOLEAN ) ) {

          /** text color **/
          if( $atts['click_state_text_color'] <> '' ) {
            $inline_css .= 'color: ' . $atts['click_state_text_color'] . ';';
          }

          /** background color **/
          if( $atts['click_state_background_color'] <> '' ) {
            $inline_css .= 'background-color: ' . $atts['click_state_background_color'] . ';';
          }

          /** border color **/
          if( $atts['click_state_border_color'] <> '' ) {
            $inline_css .= 'border-color: ' . $atts['click_state_border_color'] . ';';
          }

          /** border size **/
          if( $atts['click_state_border_size'] <> '' ) {
            $inline_css .= 'border-width: ' . $atts['click_state_border_size'] . 'px;';
          }

          /** shadow **/
          $inline_css .= 'box-shadow: ' . $atts['click_state_shadow_h_length'] . 'px ' . $atts['click_state_shadow_v_length'] . 'px ' . $atts['click_state_shadow_blur_radius'] . 'px 0px ' . $atts['click_state_shadow_color'] . ';';

          $custom_css .= ' #' . $shortcode_id . ':active { ' . $inline_css . '}';
        }

        $attributes[] = 'id="' . $shortcode_id . '"';

        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_button.php';
        return ob_get_clean();
      }

      protected function getFontsData( $atts, $paramName ) {
        $googleFontsParam = new Vc_Google_Fonts();
        $field = WPBMap::getParam( $this->shortcode, $paramName );
        $fieldSettings = isset( $field['settings'], $field['settings']['fields'] ) ? $field['settings']['fields'] : array();
        $fontsData = strlen( $atts[ $paramName ] ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $atts[ $paramName ] ) : '';

        return $fontsData;
      }

      protected function googleFontsStyles( $fontsData ) {
        // Inline styles
        $fontFamily = explode( ':', $fontsData['values']['font_family'] );
        $styles[] = 'font-family:' . $fontFamily[0];
        $fontStyles = explode( ':', $fontsData['values']['font_style'] );
        $styles[] = 'font-weight:' . $fontStyles[1];
        $styles[] = 'font-style:' . $fontStyles[2];

        return $styles;
      }

      protected function enqueueGoogleFonts( $fontsData ) {
        // Get extra subsets for settings (latin/cyrillic/etc)
        $settings = get_option( 'wpb_js_google_fonts_subsets' );
        if ( is_array( $settings ) && ! empty( $settings ) ) {
          $subsets = '&subset=' . implode( ',', $settings );
        } else {
          $subsets = '';
        }

        // We also need to enqueue font from googleapis
        if ( isset( $fontsData['values']['font_family'] ) ) {
          wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets );
        }
      }

    }
  }
