<?php

  /**
    * Blog Media Grid Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Blog_Media_Grid extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;
        
        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        wp_enqueue_style( 'wplab-albedo-blog-media-grid', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/blog_media_grid.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/blog_media_grid_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-blog-media-grid-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'fitvids' );
    		wp_enqueue_script( 'wplab-albedo-blog-media-grid', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/blog-media-grid/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

        $custom_css = '';

    		if( $atts['height'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' article { height: ' . absint( $atts['height'] ) . 'px; }';
    			$custom_css .= $inline_css;
    		}

    		if( $atts['overlay_color'] <> '' ) {
    			$inline_css = ' #' . $shortcode_id . ' article.with-thumb .overlay { background-color: ' . $atts['overlay_color'] . '; }';
    			$custom_css .= $inline_css;
    		}

        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blog_media_grid.php';
        return ob_get_clean();

      }

    }
  }
