<?php

vc_map( array(
  'name' => esc_html__( 'Blog Masonry', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_blog_masonry',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/blog-masonry.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/blog-masonry/js/vc.js',
	'category' => esc_html__( 'Blog', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add masonry blog posts grid', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Query tab
    **/

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Posts per page', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'admin_label' => true,
      'value' => '9',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query from category', 'wplab-albedo-core-plugin'),
      'param_name' => 'tax_query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All', 'wplab-albedo-core-plugin') => '',
        esc_html__('Only', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Except', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here category slugs to include or exclude, based on previous parameter. Explode multiple categories slugs by comma', 'wplab-albedo-core-plugin' ),
      'param_name' => 'tax_query_terms',
      'admin_label' => true,
      'value' => '',
      'dependency' => array(
  			'element' => 'tax_query_type',
  			'value' => array( 'only', 'except' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Featured posts only', 'wplab-albedo-core-plugin' ),
      'param_name' => 'featured_only',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Pagination tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display pagination', 'wplab-albedo-core-plugin' ),
      'param_name' => 'pagination',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Pagination', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Pagination style', 'wplab-albedo-core-plugin'),
      'param_name' => 'pagination_style',
      'dependency' => array(
  			'element' => 'pagination',
  			'not_empty' => true,
  		),
      'value' => array(
        esc_html__('Numbers', 'wplab-albedo-core-plugin') => 'number',
        esc_html__('Prev / Next links', 'wplab-albedo-core-plugin') => 'prev_next',
        esc_html__('AJAX (load more button)', 'wplab-albedo-core-plugin') => 'ajax_load_more',
        esc_html__('AJAX (infinite scroll)', 'wplab-albedo-core-plugin') => 'ajax_infinite',
      ),
      'group' => esc_html__('Pagination', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Button text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'ajax_load_more_button_text',
      'value' => esc_html__('Load more', 'wplab-albedo-core-plugin'),
      'dependency' => array(
  			'element' => 'pagination_style',
  			'value' => array( 'ajax_load_more' ),
  		),
      'group' => esc_html__('Pagination', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Button style', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Here you can choose pre-defined styles for a button', 'wplab-albedo-core-plugin'),
      'param_name' => 'ajax_load_more_button_style',
      'value' => $this->cfg['button_styles'],
      'dependency' => array(
  			'element' => 'pagination_style',
  			'value' => array( 'ajax_load_more' ),
  		),
      'group' => esc_html__('Pagination', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Appearance tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Loading effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'value' => array(
        esc_html__('Fade', 'wplab-albedo-core-plugin') => 'effect-1',
        esc_html__('Move Up', 'wplab-albedo-core-plugin') => 'effect-2',
        esc_html__('Scale up', 'wplab-albedo-core-plugin') => 'effect-3',
        esc_html__('Fall perspective', 'wplab-albedo-core-plugin') => 'effect-4',
        esc_html__('Fly', 'wplab-albedo-core-plugin') => 'effect-5',
        esc_html__('Calendar', 'wplab-albedo-core-plugin') => 'effect-6',
        esc_html__('Helix', 'wplab-albedo-core-plugin') => 'effect-7',
        esc_html__('Flip', 'wplab-albedo-core-plugin') => 'effect-8',
      ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Large screen columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'large_screen_cols',
      'value' => array(
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Medium screen columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'medium_screen_cols',
      'value' => array(
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Small screen columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'small_screen_cols',
      'value' => array(
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post date', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_date',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post media', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'post thumbnail, video, audio', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_media',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_title',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post excerpt', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_excerpt',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Excerpt lenght', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'how many words should we display?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'excerpt_length',
      'value' => '13',
      'dependency' => array(
  			'element' => 'display_excerpt',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display post categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_cats',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display link icon', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_link',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Appearance', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Style tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display shadow', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_shadow',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Custom radius for posts', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 30', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_radius',
      'value' => '',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Grid margins', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 40. This options sets margins between thumbnails', 'wplab-albedo-core-plugin' ),
      'param_name' => 'grid_margins',
      'value' => '',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Thumbnails dimensions', 'wplab-albedo-core-plugin'),
      'param_name' => 'thumbs_dimensions',
      'value' => array(
        esc_html__('Original size', 'wplab-albedo-core-plugin') => '',
        esc_html__('Crop thumbnails', 'wplab-albedo-core-plugin') => 'crop',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Thumbnail width', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 320', 'wplab-albedo-core-plugin' ),
      'param_name' => 'thumb_width',
      'value' => '320',
      'dependency' => array(
  			'element' => 'thumbs_dimensions',
  			'value' => array( 'crop' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Thumbnail height', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 320', 'wplab-albedo-core-plugin' ),
      'param_name' => 'thumb_height',
      'value' => '180',
      'dependency' => array(
  			'element' => 'thumbs_dimensions',
  			'value' => array( 'crop' ),
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

	),
));
