<?php
  global $wplab_albedo_core;
	/** unique id **/
	$attributes[] = 'id="shortcode-' . esc_attr( $atts['el_id'] ) . '"';
	$attributes[] = 'data-effect="' . esc_attr( $atts['effect'] ) . '"';
	$attributes[] = 'data-pagination="' . esc_attr( $atts['pagination'] ) . '"';
	$attributes[] = 'data-loop="' . esc_attr( $atts['loop'] ) . '"';

	if( filter_var( $atts['autoplay'], FILTER_VALIDATE_BOOLEAN ) ) {
		$attributes[] = 'data-autoplay="' . esc_attr( $atts['autoplay_speed'] ) . '"';
		$attributes[] = 'data-autoplay-stop-on-last="' . esc_attr( $atts['autoplay_stop_on_last'] ) . '"';
		$attributes[] = 'data-autoplay-disable-on-interaction="' . esc_attr( $atts['autoplay_disable_on_interaction'] ) . '"';
	}

  $terms = in_array( $atts['query_type'], array('only', 'except') ) ? $atts['cats'] : '';

  $items = $wplab_albedo_core->model('post')->get( array(
    'post_type' => 'testimonials',
    'type' => $atts['query_type'],
    'posts_per_page' => absint( $atts['posts_per_page'] ),
    'order' => $atts['order_by'],
    'sort' => $atts['sort_by'],
    'tax_name' => 'testimonials_category',
    'term_field' => 'slug',
    'terms' => $terms
  ) );

?>
<div class="shortcode-testimonials style-modern style-modern-<?php echo esc_attr( $atts['style'] ); ?> <?php echo implode(' ', $classes); ?>" <?php echo implode( ' ', $attributes ); ?>>
	<!-- Slider main container -->
	<div class="swiper-container">

    <!-- Additional required wrapper -->
    <div class="swiper-wrapper">

      <?php while ( $items->have_posts() ): $items->the_post(); ?>

      <?php
        $text = get_the_content();
        $author = fw_get_db_post_option( get_the_ID(), 'author' );
        $position = fw_get_db_post_option( get_the_ID(), 'position' );
        $photo = get_the_post_thumbnail_url( get_the_ID(), 'full');
      ?>
      <div class="swiper-slide">
        <div class="slide-content wow bg-layers bg-layers-pos-<?php echo esc_attr( $atts['bg_layers_position'] ); ?>" data-wow-delay="3000">
          <div class="bg-layer-1"></div>
          <div class="bg-layer-2"></div>
          <?php if( $photo <> '' ): ?>
          <div class="photo">
            <?php echo wplab_albedo_media::image( $photo, 120, 120, true, true, $photo ); ?>
          </div>
          <?php endif; ?>

          <?php if( $text <> '' ): ?>
          <div class="text">
            <?php echo wp_kses_post( $text ); ?>
          </div>
          <?php endif; ?>

          <div class="about-author">
            <?php if( $author <> '' ): ?>
            <div class="author">
              <?php echo wp_kses_post( $author ); ?>
            </div>
            <?php endif; ?>
            <?php if( $position <> '' ): ?>
            <div class="position">
              <?php echo wp_kses_post( $position ); ?>
            </div>
            <?php endif; ?>
          </div>

        </div>
      </div>
      <?php endwhile; wp_reset_postdata(); ?>

    </div>

	</div>

	<?php if( filter_var( $atts['pagination'], FILTER_VALIDATE_BOOLEAN ) ): ?>
  <!-- If we need pagination -->
  <div class="swiper-pagination"></div>
  <?php endif; ?>

  <?php if( filter_var( $atts['pagination_arrows'], FILTER_VALIDATE_BOOLEAN ) ): ?>
  <!-- Prev / next buttons -->
  <div class="swiper-nav-btn swiper-button-prev">
		<?php if( filter_var( $atts['p_arrows_display_prev_name'], FILTER_VALIDATE_BOOLEAN ) ): ?>
		<span class="name"></span>
		<?php endif; ?>
		<span class="title"><?php echo wp_kses_post( $atts['p_arrows_prev_title'] ); ?></span>
	</div>
  <div class="swiper-nav-btn swiper-button-next">
		<?php if( filter_var( $atts['p_arrows_display_next_name'], FILTER_VALIDATE_BOOLEAN ) ): ?>
		<span class="name"></span>
		<?php endif; ?>
		<span class="title"><?php echo wp_kses_post( $atts['p_arrow_next_title'] ); ?></span>
	</div>
  <?php endif; ?>

</div>
