<?php
$parent_atts = WPBakeryShortCode_Albedo_Tabs_Single::$parent_atts;

if( is_null( $parent_atts ) ) {
  $parent_atts = $_SESSION['albedo_iconic_tabs_shortcode_atts'];
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
?>
<div
  class="tab_content"
  data-title="<?php echo esc_attr( $atts['title'] ); ?>"
  data-animation-hover="<?php echo esc_attr( $parent_atts['animate_on_hover'] ); ?>"
  data-animation-class="<?php echo esc_attr( $parent_atts['animate_on_hover_effect'] ); ?>"
  data-icon-type="<?php echo esc_attr( $atts['icon_type'] ); ?>"
  data-icon="<?php echo $atts['icon_type'] == 'fontawesome' ? esc_attr( $atts['icon_font'] ) : esc_attr( wp_get_attachment_url( $atts['icon_image'] ) ); ?>">

  <div class="tab-content-wrapper">
    <?php
      $img_url = wp_get_attachment_url( $atts['tab_image'] );
      if( $atts['tab_image'] <> '' ):
        $img_width = is_numeric( $atts['image_width'] ) ? $atts['image_width'] : null;
        $img_height = is_numeric( $atts['image_height'] ) ? $atts['image_height'] : null;
    ?>
    <div class="tab-content-image" style="<?php echo is_numeric( $img_width ) ? 'width: ' . $img_width . 'px' : ''; ?>">

      <?php echo wplab_albedo_media::image( $img_url, $img_width, $img_height, true, true, $img_url, true ); ?>

    </div>
    <?php endif; ?>

    <div class="tab-content-text">

      <?php if( $atts['header'] <> '' ): ?><h4><?php echo wp_kses_post( $atts['header'] ); ?></h4><?php endif; ?>

      <?php echo wpautop( $content ); ?>

      <?php if( filter_var( $atts['display_button'], FILTER_VALIDATE_BOOLEAN ) ): ?>
        <p>
          <a target="_blank" href="<?php echo esc_attr( $atts['button_url'] ); ?>" class="button style-<?php echo esc_attr( $atts['button_style'] ); ?>"><?php echo wp_kses_post( $atts['button_title'] ); ?></a>
        </p>
      <?php endif; ?>

    </div>

  </div>

</div>
