<?php

$classes[] = 'overlay-color-' . esc_attr( $atts['overlay_color'] );

if( filter_var( $atts['shadows'], FILTER_VALIDATE_BOOLEAN ) ) {
	$classes[] = 'with-shadows';
}

$attributes[] = 'data-row-height="' . esc_attr( $atts['row_height'] ) . '"';
$attributes[] = 'data-max-row-height="' . esc_attr( $atts['max_row_height'] ) . '"';
$attributes[] = 'data-margins="' . esc_attr( $atts['margins'] ) . '"';
$attributes[] = 'data-captions="' . esc_attr( $atts['display_caption'] ) . '"';
$attributes[] = 'data-randomize="' . esc_attr( $atts['randomize'] ) . '"';

$images = $atts['images'] <> '' ? explode( ',', $atts['images'] ) : array();

if( count( $images ) > 0 ):
?>

<div class="images-gallery justified-gallery <?php echo implode(' ', $classes ); ?>" <?php echo implode( ' ', $attributes ); ?>>

	<?php foreach( $images as $item ): $url = wp_get_attachment_url( $item ); ?>
  <figure data-src="<?php echo esc_attr( $url ); ?>">
    <a href="<?php echo esc_attr( $url ); ?>">
      <img alt="<?php echo esc_attr( get_the_title( $item ) ); ?>" src="<?php echo esc_attr( $url ); ?>" />
    </a>
    <figcaption class="caption"><?php echo get_the_title( $item ); ?></figcaption>
  </figure>
	<?php endforeach; ?>

</div>

<?php endif;
