<?php
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );
  $choices = explode( "\n", $atts['choices'] );

  $attributes[] = 'id="field_' . esc_attr( $atts['el_id'] ) . '"';
  $attributes[] = 'name="field_' . esc_attr( $atts['el_id'] ) . '"';

?>
<div class="form-builder-item">
  <div class="field-dropdown">
    <?php if( $atts['label'] <> '' ): ?>
      <label for="field_<?php echo esc_attr( $atts['el_id'] ); ?>"><?php echo wp_kses_post( $atts['label'] ); ?></label>
    <?php endif; ?>

    <input type="hidden" name="field_<?php echo esc_attr( $atts['el_id'] ); ?>_f_label" value="<?php echo esc_attr( $atts['label'] ); ?>" />

    <select <?php echo implode( ' ', $attributes ); ?>>
      <?php if( is_array( $choices ) && count( $choices ) > 0 ): foreach( $choices as $choice ): $choice = strip_tags( $choice ); ?>
        <option value="<?php echo esc_attr( $choice ); ?>"><?php echo wp_kses_post( $choice ); ?></option>
      <?php endforeach; endif; ?>
    </select>

    <?php if( $atts['description'] <> '' ): ?>
    <p class="instructions">
      <em><?php echo wp_kses_post( $atts['description'] ); ?></em>
    </p>
    <?php endif; ?>

  </div>
</div>
