<?php

vc_map( array(
  'name' => esc_html__( 'Team Members Tabs', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_team_tabs',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/team-members-tab.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/team-tabs/js/vc.js',
	'category' => esc_html__( 'Team', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add team members', 'wplab-albedo-core-plugin' ),
	'params' => array(

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('All Team Members', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Team Members only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Team Members except categories', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slides count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'admin_label' => true,
      'value' => '10',
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'admin_label' => true,
      'value' => '',
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('Query', 'wplab-albedo-core-plugin'),
    ),

    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Block title', 'wplab-albedo-core-plugin' ),
      'param_name' => 'block_title',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Block text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'block_text',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animation_effect',
      'save_always' => true,
      'value' => $this->cfg['animations'],
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

  )
));
