<?php

  /**
    * Team Members Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Team_Members extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;
        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load static stylesheet **/
    		wp_enqueue_style( 'wplab-albedo-team-members', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/team_members.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/team_members_variable.less') );
        wp_enqueue_style( 'wplab-albedo-team-members-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-team-members', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/team-members/static/js/scripts.js'), array('jquery'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_team_members.php';
        return ob_get_clean();

      }

    }
  }
