<?php

  /**
    * Portfolio Posts Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Portfolio_Posts extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $wrap_attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        /** load stylesheet **/
    		if( filter_var( $atts['filters'], FILTER_VALIDATE_BOOLEAN ) ) {
          $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/filters.less') );
    			wp_enqueue_style( 'wplab-albedo-filters-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		}

    		/** include Masonry Grid **/
    		wp_enqueue_style( 'masonry', get_template_directory_uri() . '/css/libs/masonry.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    		wp_enqueue_style( 'masonry-effects', get_template_directory_uri() . '/css/libs/masonry_effects.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
        wp_dequeue_script( 'isotope');
        wp_register_script( 'albedo-isotope', wplab_albedo_utils::locate_uri( '/js/libs/isotope.pkgd.min.js'), array( 'jquery' ), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_enqueue_script( 'albedo-isotope' );
    		wp_enqueue_script( 'anim-on-scroll' );

    		wp_enqueue_style( 'wplab-albedo-portfolio-posts', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/portfolio_posts.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/portfolio_posts_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-portfolio-posts-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		$js_vars = array();

    		/** include LightGallery library styles **/
    		if( filter_var( $atts['display_lightbox_icon'], FILTER_VALIDATE_BOOLEAN ) ) {
    			wp_enqueue_style( 'lightgallery', get_template_directory_uri() . '/css/libs/lightgallery.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    			wp_enqueue_style( 'lightgallery-transitions', get_template_directory_uri() . '/css/libs/lg-transitions.min.css', false, _WPLAB_ALBEDO_CACHE_TIME_ );
    			wp_enqueue_script( 'lightgallery');

    			/** shortcode script **/
    			$js_vars = array(
    				'lightboxEffect' => fw_get_db_customizer_option( 'lightbox_effect' ),
    				'lightboxEasing' => fw_get_db_customizer_option( 'lightbox_easing' ),
    				'lightboxThumbs' => filter_var( fw_get_db_customizer_option( 'lightbox_thumbnails' ), FILTER_VALIDATE_BOOLEAN ),
    				'lightboxCaptions' => filter_var( fw_get_db_customizer_option( 'lightbox_captions' ), FILTER_VALIDATE_BOOLEAN ),
    				'lightboxFullscreen' => filter_var( fw_get_db_customizer_option( 'lightbox_fullscreen' ), FILTER_VALIDATE_BOOLEAN ),
    				'lightboxZoom' => filter_var( fw_get_db_customizer_option( 'lightbox_zoom' ), FILTER_VALIDATE_BOOLEAN ),
    				'lightboxDownload' => filter_var( fw_get_db_customizer_option( 'lightbox_download' ), FILTER_VALIDATE_BOOLEAN ),
    				'lightboxAutoplay' => filter_var( fw_get_db_customizer_option( 'lightbox_autoplay/enabled' ), FILTER_VALIDATE_BOOLEAN ),
    				'lightboxAutoplaySpeed' => absint( fw_get_db_customizer_option( 'lightbox_autoplay/yes/speed' ) ),
    			);

    			if( $js_vars['lightboxThumbs'] == true ) {
    				wp_enqueue_script( 'lightgallery-thumb');
    			}
    			if( $js_vars['lightboxFullscreen'] == true ) {
    				wp_enqueue_script( 'lightgallery-fullscreen');
    			}
    			if( $js_vars['lightboxAutoplay'] == true ) {
    				wp_enqueue_script( 'lightgallery-autoplay');
    			}
    			if( $js_vars['lightboxZoom'] == true ) {
    				wp_enqueue_script( 'lightgallery-zoom');
    			}

    		}

    		wp_enqueue_script( 'wplab-albedo-portfolio-posts', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/portfolio-posts/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );
    		wp_localize_script( 'wplab-albedo-portfolio-posts', 'wplabAlbedoPortfolioMasonryGrid', $js_vars );

    		/**
    		 * Custom style settings
    		 **/
        $custom_css = '';

    		if( $atts['filters_link_color'] <> '' ) {
    			$custom_css .= '#' . $shortcode_id . ' .posts-filters a { color: ' . $atts['filters_link_color'] . '; }';
    		}

    		if( $atts['filters_link_active_color'] <> '' ) {
    			$custom_css .= '#' . $shortcode_id . ' .posts-filters a.active, #' . $shortcode_id . ' .posts-filters a:hover { color: ' . $atts['filters_link_active_color'] . '; }';
    		}

    		if( $atts['filters_separator_color'] <> '' ) {
    			$custom_css .= '#' . $shortcode_id . ' .posts-filters { color: ' . $atts['filters_separator_color'] . '; }';
    		}

        if( $custom_css <> '' ) {
          $wrap_attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_portfolio_posts.php';
        return ob_get_clean();

      }

    }
  }
