<?php

vc_map( array(
  'name' => esc_html__( 'Presentation Slider', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_presentation_slider',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/presentation-slider.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/media-presentation/js/vc.js',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add presentation slider', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     * General tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query type', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'value' => array(
        esc_html__('All Media Slides', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Media Slides only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Media Slides except categories', 'wplab-albedo-core-plugin') => 'except',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Slides count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '3',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'value' => '',
      'dependency' => array(
        'element' => 'query_type',
        'value' => array( 'only', 'except' ),
      ),
      'description' => esc_html__( 'Type here categories slugs, e.g. my-category', 'wplab-albedo-core-plugin' ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu_order',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     * Carousel tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Use Mouse Wheel to scroll slides?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'mousewheel',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Pagination', 'wplab-albedo-core-plugin' ),
      'param_name' => 'pagination',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Autoplay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Autoplay speed', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in milliseconds, e.g.: 2000 = 2 seconds', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_speed',
      'value' => '2000',
      'save_always' => true,
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Stop on last slide', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enable this parameter and autoplay will be stopped when it reaches last slide (has no effect in loop mode)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_stop_on_last',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Disable autoplay on iteration', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set to false and autoplay will not be disabled after user interactions, it will be restarted every time after interaction', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_disable_on_interaction',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Loop slider', 'wplab-albedo-core-plugin' ),
      'param_name' => 'loop',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),

    /**
     * Style tab
    **/

    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Accent color', 'wplab-albedo-core-plugin'),
      'param_name' => 'accent_color',
      'value' => $this->cfg['base_colors'],
      'save_always' => true,
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Cover featured image', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cover_featured_image',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Featured image position', 'wplab-albedo-core-plugin'),
      'param_name' => 'featured_image_position',
      'save_always' => true,
      'value' => array(
        esc_html__('Left Top', 'wplab-albedo-core-plugin') => 'left top',
        esc_html__('Center Top', 'wplab-albedo-core-plugin') => 'center top',
        esc_html__('Right Top', 'wplab-albedo-core-plugin') => 'right top',
        esc_html__('Left Bottom', 'wplab-albedo-core-plugin') => 'left bottom',
        esc_html__('Center Bottom', 'wplab-albedo-core-plugin') => 'center bottom',
        esc_html__('Right Bottom', 'wplab-albedo-core-plugin') => 'right bottom',
        esc_html__('Left Center', 'wplab-albedo-core-plugin') => 'left center',
        esc_html__('Center Center', 'wplab-albedo-core-plugin') => 'center center',
        esc_html__('Right Center', 'wplab-albedo-core-plugin') => 'right center',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Fixed featured image', 'wplab-albedo-core-plugin' ),
      'param_name' => 'fixed_featured_image',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),


  )
));
