<?php

vc_map( array(
  'name' => esc_html__( 'Images Carousel', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_images_carousel',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/image-carousel.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/media-image-carousel/js/vc.js',
	'category' => esc_html__( 'Media', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add images carousel', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/
    array(
      'type' => 'attach_images',
      'heading' => esc_html__('Choose images', 'wplab-albedo-core-plugin'),
      'param_name' => 'images',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Carousel tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Images width', 'wplab-albedo-core-plugin' ),
      'param_name' => 'image_width',
      'value' => '',
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Images height', 'wplab-albedo-core-plugin' ),
      'param_name' => 'image_height',
      'value' => '',
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Carousel Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'save_always' => true,
      'value' => array(
        esc_html__('Slide', 'wplab-albedo-core-plugin') => 'slide',
        esc_html__('Fade', 'wplab-albedo-core-plugin') => 'fade',
        esc_html__('Cube', 'wplab-albedo-core-plugin') => 'cube',
        esc_html__('Coverflow', 'wplab-albedo-core-plugin') => 'coverflow',
        esc_html__('Flip', 'wplab-albedo-core-plugin') => 'flip',
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display image caption', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_caption',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Pagination', 'wplab-albedo-core-plugin' ),
      'param_name' => 'pagination',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Autoplay', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Autoplay speed', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'in milliseconds, e.g.: 2000 = 2 seconds', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_speed',
      'value' => '2000',
      'save_always' => true,
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Stop on last slide', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Enable this parameter and autoplay will be stopped when it reaches last slide (has no effect in loop mode)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_stop_on_last',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Disable autoplay on iteration', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Set to false and autoplay will not be disabled after user interactions, it will be restarted every time after interaction', 'wplab-albedo-core-plugin' ),
      'param_name' => 'autoplay_disable_on_interaction',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'dependency' => array(
        'element' => 'autoplay',
        'not_empty' => true,
      ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Loop slider', 'wplab-albedo-core-plugin' ),
      'param_name' => 'loop',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Carousel', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Responsive Settings tab
    **/
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (big screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_big',
      'value' => '3',
      'save_always' => true,
      'group' => esc_html__('Responsive Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (medium screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_medium',
      'value' => '2',
      'save_always' => true,
      'group' => esc_html__('Responsive Settings', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Visible items (small screen)', 'wplab-albedo-core-plugin' ),
      'param_name' => 'items_small',
      'value' => '1',
      'save_always' => true,
      'group' => esc_html__('Responsive Settings', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Style tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Add hover effect?', 'wplab-albedo-core-plugin' ),
      'param_name' => 'hover_effects',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Hover Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'hover_style',
      'save_always' => true,
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Slide (from right to left)', 'wplab-albedo-core-plugin') => 'slide-right-left',
        esc_html__('Zoom Out', 'wplab-albedo-core-plugin') => 'zoom-out',
        esc_html__('Zoom In', 'wplab-albedo-core-plugin') => 'zoom-in',
        esc_html__('Big Zoom', 'wplab-albedo-core-plugin') => 'big-zoom',
        esc_html__('Zoom 3D', 'wplab-albedo-core-plugin') => 'zoom-3d',
        esc_html__('Zoom and Slide', 'wplab-albedo-core-plugin') => 'zoom-slide',
        esc_html__('Shine', 'wplab-albedo-core-plugin') => 'shine',
      ),
      'dependency' => array(
  			'element' => 'hover_effects',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Border radius for images', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'value in pixels, e.g.: 20. This option may not work if you are using hover effects', 'wplab-albedo-core-plugin' ),
      'param_name' => 'border_radius',
      'value' => '',
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

  )
));
