<?php

vc_map( array(
  'name' => esc_html__( 'Line', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_line',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/line.png',
	'category' => esc_html__( 'Content Elements', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add colorful line', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Line color', 'wplab-albedo-core-plugin'),
      'param_name' => 'line_color',
      'save_always' => true,
      'value' => $this->cfg['base_colors'],
    ),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Custom line color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'custom_color',
  		'value' => '',
  	),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Corners radius', 'wplab-albedo-core-plugin' ),
      'param_name' => 'corners_radius',
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Line width', 'wplab-albedo-core-plugin' ),
      'param_name' => 'max_width',
      'value' => '',
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Custom margins', 'wplab-albedo-core-plugin' ),
      'param_name' => 'margins',
      'value' => '',
    ),

  )
));
