<?php

  /**
    * Single Blog Post Shortcode
  **/

  // Map VC shortcode
  require_once 'config.php';

  if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_Albedo_Blog_Post extends WPBakeryShortCode {

      protected function content( $atts, $content = null ) {
        global $wplab_albedo_core_plugin;

        $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

        $attributes = $classes = array();

        $shortcode_id = 'shortcode-' . $atts['el_id'];

    		$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

        wp_enqueue_style( 'wplab-albedo-shortcode-blog-post', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/blog_post.css'), false, _WPLAB_ALBEDO_CACHE_TIME_ );
        $variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/blog_post_variable.less') );
    		wp_enqueue_style( 'wplab-albedo-shortcode-blog-post-variable', $variable_style, false, _WPLAB_ALBEDO_CACHE_TIME_ );

    		/**
    		 * Shortcode scripts
    		 **/
    		wp_enqueue_script( 'wplab-albedo-shortcode-blog-post', wplab_albedo_utils::locate_uri('/framework-customizations/extensions/shortcodes/shortcodes/blog-post/static/js/scripts' . $postfix . '.js'), array('jquery'), _WPLAB_ALBEDO_CACHE_TIME_, true );

    		// custom Css
        $custom_css = '';
    		if( $atts['custom_radius'] <> '' ) {
    			$radius = absint( $atts['custom_radius'] );
    			$custom_css .= ' #' . $shortcode_id . ', #' . $shortcode_id . ' .inside, #' . $shortcode_id . ' .overlay { border-radius: ' . $radius . 'px; }';
    		}

    		if( $atts['custom_paddings'] <> '' ) {
    			$paddings = absint( $atts['custom_paddings'] );
    			$custom_css .= ' #' . $shortcode_id . ' .inside { padding: ' . $paddings . 'px; }';
    		}

        if( $custom_css <> '' ) {
          $attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
        }

        ob_start();
        require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_blog_post.php';
        return ob_get_clean();

      }

    }
  }
