<?php

vc_map( array(
  'name' => esc_html__( 'Blockquote', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_blockquote',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/blockquote.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/blockquote/js/vc.js',
	'category' => esc_html__( 'Testimonials', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add cite / blockquote', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  General tab
    **/

    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Quote text', 'wplab-albedo-core-plugin' ),
      'param_name' => 'text',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Author', 'wplab-albedo-core-plugin' ),
      'param_name' => 'author',
      'admin_label' => true,
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Position', 'wplab-albedo-core-plugin' ),
      'param_name' => 'position',
      'value' => '',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Style', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'save_always' => true,
      'value' => array(
        esc_html__('Standard Blockquote', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Accent Blockquote', 'wplab-albedo-core-plugin') => 'accent',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Styling tab
    **/
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Custom font family', 'wplab-albedo-core-plugin' ),
      'param_name' => 'custom_font_family',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
    ),
    array(
			'type' => 'google_fonts',
			'param_name' => 'google_fonts',
			'value' => '',
      'dependency' => array(
  			'element' => 'custom_font_family',
  			'not_empty' => true,
  		),
			'settings' => array(
				'fields' => array(
					'font_family_description' => __( 'Select font family.', 'wplab-albedo-core-plugin' ),
					'font_style_description' => __( 'Select font styling.', 'wplab-albedo-core-plugin' ),
				),
			),
      'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
		),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Background color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'background_color',
  		'value' => '',
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Quotes decor color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'quotes_color',
  		'value' => '',
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Quote text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'text_color',
  		'value' => '',
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Author text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'author_color',
  		'value' => '',
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),
    array(
  		'type' => 'colorpicker',
  		'heading' => esc_html__( 'Position text color', 'wplab-albedo-core-plugin' ),
  		'param_name' => 'position_color',
  		'value' => '',
  		'group' => esc_html__('Styling', 'wplab-albedo-core-plugin'),
  	),

    /*
      Margins tab
    */
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Blockquote Margins', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'margins',
       'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Blockquote Margins (for medium screens)', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'margins_medium',
       'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Blockquote Margins (for small screens)', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'margins_mobile',
       'group' => esc_html__('Margins', 'wplab-albedo-core-plugin'),
    ),

    /*
      Paddings tab
    */
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Blockquote Paddings', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings',
       'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Blockquote Paddings (for medium screens)', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings_medium',
       'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
    ),
    array(
       'type' => 'albedo_sides_box',
       'heading' => esc_html__( 'Blockquote Paddings (for small screens)', 'wplab-albedo-core-plugin' ),
       'description' => esc_html__( 'Example: 10px 20% 20px 20%. Follow clockwise: top, right, bottom, left', 'wplab-albedo-core-plugin' ),
       'param_name' => 'paddings_mobile',
       'group' => esc_html__('Paddings', 'wplab-albedo-core-plugin'),
    ),


  )
));
