<?php

vc_map( array(
  'name' => esc_html__( 'Benefits with filters', 'wplab-albedo-core-plugin' ),
	'base' => 'albedo_benefits_filters',
  'icon' => $this->plugin_uri . '/assets/shortcode_icons/benefits-with-filters.png',
  'front_enqueue_js' => $this->plugin_uri . '/shortcodes/benefits-v2/js/vc.js',
	'category' => esc_html__( 'Services', 'wplab-albedo-core-plugin' ),
	'description' => esc_html__( 'Add benefits with filters', 'wplab-albedo-core-plugin' ),
	'params' => array(

    /**
     *  Query tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Query', 'wplab-albedo-core-plugin'),
      'param_name' => 'query_type',
      'admin_label' => true,
      'value' => array(
        esc_html__('Display all Benefits posts', 'wplab-albedo-core-plugin') => 'all',
        esc_html__('Display Benefits only from selected categories', 'wplab-albedo-core-plugin') => 'only',
        esc_html__('Display all, except selected categories', 'wplab-albedo-core-plugin') => 'except',
        esc_html__('Display child from selected category', 'wplab-albedo-core-plugin') => 'all_child',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Benefits count', 'wplab-albedo-core-plugin' ),
      'param_name' => 'posts_per_page',
      'value' => '10',
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textarea',
      'heading' => esc_html__( 'Categories', 'wplab-albedo-core-plugin' ),
      'description' => esc_html__( 'Type here categories slug, e.g.: my-category', 'wplab-albedo-core-plugin' ),
      'param_name' => 'cats',
      'value' => '',
      'dependency' => array(
  			'element' => 'query_type',
  			'value' => array( 'include', 'exclude', 'all_child' ),
  		),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'order_by',
      'value' => array(
        esc_html__('Date', 'wplab-albedo-core-plugin') => 'date',
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Modified date', 'wplab-albedo-core-plugin') => 'modified',
        esc_html__('Title', 'wplab-albedo-core-plugin') => 'title',
        esc_html__('Random', 'wplab-albedo-core-plugin') => 'rand',
        esc_html__('Menu', 'wplab-albedo-core-plugin') => 'menu',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Posts sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'el_id',
      'heading' => esc_html__( 'Element ID', 'wplab-albedo-core-plugin' ),
      'param_name' => 'el_id',
      'settings' => array(
        'auto_generate' => true,
      ),
      'group' => esc_html__('General', 'wplab-albedo-core-plugin'),
      'description' => esc_html__( 'Unique identifier of this element', 'wplab-albedo-core-plugin' ),
    ),

    /**
     *  Style tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Style', 'wplab-albedo-core-plugin'),
      'description' => esc_html__('Choose from one of available styles', 'wplab-albedo-core-plugin'),
      'param_name' => 'style',
      'admin_label' => true,
      'value' => array(
        esc_html__('Default', 'wplab-albedo-core-plugin') => 'default',
        esc_html__('Alternate', 'wplab-albedo-core-plugin') => 'alt',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Scroll navigation', 'wplab-albedo-core-plugin' ),
      'param_name' => 'scroll_nav',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'textfield',
      'heading' => esc_html__( 'Scroll top offset', 'wplab-albedo-core-plugin' ),
      'param_name' => 'scroll_nav_offset_top',
      'value' => '40',
      'dependency' => array(
  			'element' => 'scroll_nav',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Columns', 'wplab-albedo-core-plugin'),
      'param_name' => 'cols',
      'value' => array(
        '4' => '4',
        '3' => '3',
        '2' => '2',
        '1' => '1',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display filters', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_filters',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Display All filter link', 'wplab-albedo-core-plugin' ),
      'param_name' => 'display_filters_all_button',
      'dependency' => array(
  			'element' => 'display_filters',
  			'not_empty' => true,
  		),
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Terms ordering method', 'wplab-albedo-core-plugin'),
      'param_name' => 'terms_order_by',
      'value' => array(
        esc_html__('ID', 'wplab-albedo-core-plugin') => 'ID',
        esc_html__('Count', 'wplab-albedo-core-plugin') => 'count',
        esc_html__('Name', 'wplab-albedo-core-plugin') => 'name',
        esc_html__('Slug', 'wplab-albedo-core-plugin') => 'slug',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Terms sorting method', 'wplab-albedo-core-plugin'),
      'param_name' => 'terms_sort_by',
      'value' => array(
        esc_html__('Descending', 'wplab-albedo-core-plugin') => 'DESC',
        esc_html__('Ascending', 'wplab-albedo-core-plugin') => 'ASC',
      ),
      'group' => esc_html__('Style', 'wplab-albedo-core-plugin'),
    ),

    /**
     *  Animation tab
    **/
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Loading effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'effect',
      'value' => array(
        esc_html__('Fade', 'wplab-albedo-core-plugin') => 'effect-1',
        esc_html__('Move Up', 'wplab-albedo-core-plugin') => 'effect-2',
        esc_html__('Scale up', 'wplab-albedo-core-plugin') => 'effect-3',
        esc_html__('Fall perspective', 'wplab-albedo-core-plugin') => 'effect-4',
        esc_html__('Fly', 'wplab-albedo-core-plugin') => 'effect-5',
        esc_html__('Calendar', 'wplab-albedo-core-plugin') => 'effect-6',
        esc_html__('Helix', 'wplab-albedo-core-plugin') => 'effect-7',
        esc_html__('Flip', 'wplab-albedo-core-plugin') => 'effect-8',
      ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'checkbox',
      'heading' => esc_html__( 'Animate elements on hover', 'wplab-albedo-core-plugin' ),
      'param_name' => 'animate_on_hover',
      'value' => array( esc_html__( 'Yes', 'wplab-albedo-core-plugin' ) => 'yes' ),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('Animation Effect', 'wplab-albedo-core-plugin'),
      'param_name' => 'animate_on_hover_effect',
      'value' => $this->cfg['animations'],
      'dependency' => array(
  			'element' => 'animate_on_hover',
  			'not_empty' => true,
  		),
      'group' => esc_html__('Animation', 'wplab-albedo-core-plugin'),
    ),


	),
));
