<?php

	/**
		* Benefits Numeric / Shortcode
	**/

	// Map VC shortcode
	require_once 'config.php';

	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
		class WPBakeryShortCode_Albedo_Benefits_Numeric extends WPBakeryShortCode {

			protected function content( $atts, $content = null ) {

				$atts = vc_map_get_attributes( $this->getShortcode(), $atts );

				fw()->backend->option_type('icon-v2')->packs_loader->enqueue_frontend_css();

				$attributes = $classes = array();

				$shortcode_id = 'shortcode-' . $atts['el_id'];

				$postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';

				/** load stylesheet **/
				wp_enqueue_style( 'wplab-albedo-benefits-numeric', wplab_albedo_utils::locate_uri( '/css/front/css/shortcodes/benefits_numeric.css'), false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

				global $wplab_albedo_core_plugin;
				$variable_style = $wplab_albedo_core_plugin->lessify( wplab_albedo_utils::locate_uri( '/css/front/less/shortcodes/benefits_numeric_variable.less') );
				wp_enqueue_style( 'wplab-albedo-benefits-numeric-variable', $variable_style, false, _WPLAB_ALBEDO_CORE_CACHE_TIME_ );

				/**
				 * Custom colors
				 **/

				$custom_css = '';

				if( $atts['number_color'] <> '' ) {
					$inline_css = ' #' . $shortcode_id . ' .number { color: ' . $atts['number_color'] . '; }';
					$custom_css .= $inline_css;
				}

				if( $atts['number_hover_color'] <> '' ) {
					$inline_css = ' #' . $shortcode_id . ' .number { color: ' . $atts['number_hover_color'] . '; }';
					$custom_css .= $inline_css;
				}

				if( $atts['header_color'] <> '' ) {
					$inline_css = ' #' . $shortcode_id . ' h4 { color: ' . $atts['header_color'] . '; }';
					$custom_css .= $inline_css;
				}

				if( $atts['header_hover_color'] <> '' ) {
					$inline_css = ' #' . $shortcode_id . ' .item:hover h4 { color: ' . $atts['header_hover_color'] . '; }';
					$custom_css .= $inline_css;
				}

				if( $atts['text_color'] <> '' ) {
					$inline_css = ' #' . $shortcode_id . ' .desc { color: ' . $atts['text_color'] . '; }';
					$custom_css .= $inline_css;
				}

				if( $custom_css <> '' ) {
					$attributes[] = 'data-custom-css=\'' . $custom_css . '\'';
				}

				ob_start();
				require plugin_dir_path( __FILE__ ) . '/../../vc_templates/albedo_benefits_numeric.php';
				return ob_get_clean();

			}

		}
	}
