<?php
  global $wplab_albedo_core_plugin;
  $atts = vc_map_get_attributes( $this->getShortcode(), $atts );

  $postfix = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
  $bg_image = is_numeric( $atts['background_image'] ) ? wp_get_attachment_url( $atts['background_image'] ) : '';
  $css_classes = $attributes = $outer_css_classes = $outer_atts = array();

  $flex_row = $video_parallax = $bg_layers = $particles = false;

  // ID should start from letter
  if( strlen( $atts['el_id'] ) > 0 && ctype_digit(substr( $atts['el_id'] , 0, 1)) ) {
    $atts['el_id'] = 'shortcode-' . $atts['el_id'];
  }

  $shortcode_id = $main_row_id = $atts['el_id'];

  /**
   * Scripts, custom styles etc...
  **/
  include $wplab_albedo_core_plugin->plugin_src . '/shortcodes/row/static.php';

  $video_parallax = false;

  /**
   * Custom CSS Classes
   **/
  if( $atts['el_class'] <> '' ) {
  	$css_classes[] = esc_attr( $atts['el_class'] );
  }

  if( $atts['el_class'] <> '' ) {
    $css_classes[] = $atts['el_class'];
  }
  $css_classes[] = 'vc_row wpb_row vc_row-fluid';
  $css_classes[] = $this->getCSSAnimation( $atts['css_animation'] );

  if ( 'yes' === $atts['disable_element'] ) {
  	if ( vc_is_page_editable() ) {
  		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
  	} else {
  		return '';
  	}
  }

  if ( ! empty( $atts['gap'] ) ) {
  	$css_classes[] = 'vc_column-gap-' . $atts['gap'];
  }

  if ( ! empty( $atts['full_height'] ) ) {
  	$css_classes[] = 'vc_row-o-full-height';
  }

  if ( ! empty( $atts['content_placement'] ) ) {
  	$flex_row = true;
  	$css_classes[] = 'vc_section-o-content-' . $atts['content_placement'];
  }

  if ( ! empty( $flex_row ) ) {
  	$css_classes[] = 'vc_section-flex';
  }

  if( filter_var( $atts['background_fixed'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'fixed-bg-section';
  }

  if( filter_var( $atts['background_fixed'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'fixed-bg-section';
  }

  if( $atts['section_style'] <> '' ) {
  	if( $atts['section_style'] == 'boxed_rounded' ) {
  		$outer_css_classes[] = 'box-element box-rounded';
  	} elseif( $atts['section_style'] == 'boxed' ) {
  		$outer_css_classes[] = 'box-element box-square';
  	} else {
  		$css_classes[] = $atts['section_style'];
  		$css_classes[] = 'wow';
  		$bg_layers = true;
  	}
  }

  if( filter_var( $atts['hide_bg_large_screens'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'bgimage-hidden-lg';
  }

  if( filter_var( $atts['hide_bg_medium_screens'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'bgimage-hidden-md';
  }

  if( filter_var( $atts['hide_bg_small_screens'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'bgimage-hidden-sm';
  }

  if( filter_var( $atts['hide_bg_estra_small_screens'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'bgimage-hidden-xs';
  }

  if( filter_var( $atts['hide_lg'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'hidden-lg';
  }

  if( filter_var( $atts['hide_md'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'hidden-md';
  }

  if( filter_var( $atts['hide_sm'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'hidden-sm';
  }

  if( filter_var( $atts['hide_xs'], FILTER_VALIDATE_BOOLEAN ) ) {
  	$css_classes[] = 'hidden-xs';
  }

  if ( ! empty( $atts['full_width'] ) ) {
  	$attributes[] = 'data-vc-full-width="true"';
  	$attributes[] = 'data-vc-full-width-init="false"';
  	if ( 'stretch_row_content' === $atts['full_width'] ) {
  		$attributes[] = 'data-vc-stretch-content="true"';
  	} elseif ( 'stretch_row_content_no_spaces' === $atts['full_width'] ) {
  		$attributes[] = 'data-vc-stretch-content="true"';
  		$css_classes[] = 'vc_row-no-padding';
  	}
  }

  /**
   * Section effects
   **/

  if( $atts['parallax_effects'] <> '' ) {
  	/**
  	 * Parallax Background Effect
  	 **/
  	if( $atts['parallax_effects'] == 'parallax' ) {
  		$parallax_speed = $atts['parallax_speed'] <> '' ? $atts['parallax_speed'] : '0.2';
  		if( $bg_image <> '' ) {
  			$css_classes[] = 'parallax-section';
  			$attributes[] = 'data-stellar-background-ratio="' . esc_attr( $parallax_speed ) . '"';
  			$attributes[] = 'data-lazy-src="' . esc_attr( $bg_image ) . '"';
  			$css_classes[] = 'b-lazy';
  		}
  	}

  	/**
  	 * Mouse parallax
  	 **/
  	elseif( $atts['parallax_effects'] == 'mouse_parallax' ) {
  		$css_classes[] = 'parallax-js-section';
  	}
  	/**
  	 * Scrollr Effect
  	 **/
  	elseif( $atts['parallax_effects'] == 'scroll_animation' ) {
  		$css_classes[] = 'skrollr';
  		$attributes[] = 'data-0="' . esc_attr( $atts['scroll_animation_start_css'] ) . '"';
  		$attributes[] = 'data-' . absint( $atts['mouse_parallax_end_pos'] ) . '="' . esc_attr( $atts['scroll_animation_end_css'] ) . '"';
  	}
  }

  if( $atts['section_effects'] <> '' ) {

  	/**
  	 * YouTube Video Background Effect
  	 **/
  	if( $atts['section_effects'] == 'video' ) {
  		$css_classes[] = 'video-bg-section';
  		if( $atts['section_effect_video_parallax_speed'] <> '' ) {
  			$attributes[] = 'data-video-fallabck="' . wp_get_attachment_url( $atts['section_effect_video_fallback_img'] ) . '"';
  			$css_classes[] = 'video-parallax';
  			$video_parallax = true;
  		}
  	}

  	/**
  	 * Particle Groud Effect
  	 **/
  	elseif( $atts['section_effects'] == 'particleground' ) {
  		$css_classes[] = 'particle-ground-section';
  		$attributes[] = 'data-dot-color="' . esc_attr( $atts['particleground_dots_color'] ) . '"';
  		$attributes[] = 'data-line-color="' . esc_attr( $atts['particleground_lines_color'] ) . '"';
  		$attributes[] = 'data-particle-radius="' . esc_attr( $atts['particleground_dot_size'] ) . '"';
  		$attributes[] = 'data-line-width="' . esc_attr( $atts['particleground_line_width'] ) . '"';
  		$attributes[] = 'data-curved-lines="' . esc_attr( $atts['particleground_curved_lines'] ) . '"';
  		$attributes[] = 'data-parallax="' . esc_attr( $atts['particleground_parallax'] ) . '"';
  		$attributes[] = 'data-parallax-multiplier="' . esc_attr( $atts['particleground_parallax_multiplier'] ) . '"';
  		$attributes[] = 'data-proximity="' . esc_attr( $atts['particleground_proximity'] ) . '"';
  		$attributes[] = 'data-min-speed-x="' . esc_attr( $atts['particleground_min_speed_x'] ) . '"';
  		$attributes[] = 'data-max-speed-x="' . esc_attr( $atts['particleground_max_speed_x'] ) . '"';
  		$attributes[] = 'data-min-speed-y="' . esc_attr( $atts['particleground_min_speed_y'] ) . '"';
  		$attributes[] = 'data-max-speed-y="' . esc_attr( $atts['particleground_max_speed_y'] ) . '"';
  		$attributes[] = 'data-direction-x="' . esc_attr( $atts['particleground_direction_x'] ) . '"';
  		$attributes[] = 'data-direction-y="' . esc_attr( $atts['particleground_direction_y'] ) . '"';
  		$attributes[] = 'data-destiny="' . esc_attr( $atts['particleground_destiny'] ) . '"';
  	}

  	/**
  	 * Particles Effect
  	 **/
  	elseif( $atts['section_effects'] == 'particles' ) {
  		$particles = true;
  	}

  }

  /**
   * Lazy load bg image
   **/
  if( filter_var( $atts['background_lazy'], FILTER_VALIDATE_BOOLEAN ) && $bg_image <> '' ) {
  	$css_classes[] = 'b-lazy';
  	$attributes[] = 'data-lazy-src="' . esc_attr( $bg_image ) . '"';
  }

  /**
   * Attributes
   **/
   $centered_content = false;
   if( filter_var( $atts['full_height'], FILTER_VALIDATE_BOOLEAN ) ) {
   	$css_classes[] = 'full-height-section';
   	if( filter_var( $atts['center_content'], FILTER_VALIDATE_BOOLEAN ) ) {
   		$centered_content = true;
   		$css_classes[] = 'full-height-centered';
   	}
   }

  /**
  * Is Full-width container
  **/
  $sidebar_position = function_exists('fw_ext_sidebars_get_current_position') ? fw_ext_sidebars_get_current_position() : 'right';
  if( is_null( $sidebar_position ) ) {
  	$sidebar_position = 'right';
  }
  $p_tpl = basename( get_page_template() );
  if( $p_tpl == 'page-template-custom.php' || $p_tpl == 'page-template-no-header-footer.php' ) {
  	$sidebar_position = 'full';
  }

  $container_stretch = ( isset( $atts['container_stretch'] ) && ( $atts['container_stretch'] == 'stretch_row_content' || $atts['container_stretch'] == 'stretch_row_content_no_paddings' ) );

  $css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ), $this->settings['base'], $atts ) );
  $attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';
  $attributes[] = 'id="' . esc_attr( $shortcode_id ) . '"';

  $display_outer = count( $outer_css_classes ) > 0;
  ?>
<?php if( $display_outer ): ?>
<div <?php echo implode(' ', $outer_atts); ?> class="<?php echo implode(' ', $outer_css_classes); ?>">
<?php endif; ?>

  <div <?php echo implode( ' ', $attributes ); ?>>
  	<?php
  	if( $atts['parallax_effects'] == 'mouse_parallax' && $bg_image <> '' ):
      wp_enqueue_script( 'parallax');
      wp_enqueue_script( 'wplab-albedo-section-parallax', $wplab_albedo_core_plugin->tpl_url . '/framework-customizations/extensions/shortcodes/shortcodes/section/static/js/mouse_parallax.js', array('parallax'), _WPLAB_ALBEDO_CORE_CACHE_TIME_, true );
    ?>

  	<ul class="parallax-scene"
  			data-invert-x="<?php echo filter_var( $atts['mouse_parallax_invert_x'], FILTER_VALIDATE_BOOLEAN ) ? 'true' : 'false'; ?>"
  			data-invert-y="<?php echo filter_var( $atts['mouse_parallax_invert_y'], FILTER_VALIDATE_BOOLEAN ) ? 'true' : 'false'; ?>"
  			data-limit-x="<?php echo esc_attr( $atts['mouse_parallax_limit_x'] ); ?>"
  			data-limit-y="<?php echo esc_attr( $atts['mouse_parallax_limit_y'] ); ?>"
  			data-scalar-x="<?php echo esc_attr( $atts['mouse_parallax_scalar_x'] ); ?>"
  			data-scalar-y="<?php echo esc_attr( $atts['mouse_parallax_scalar_y'] ); ?>"
  			data-friction-x="<?php echo esc_attr( $atts['mouse_parallax_friction_x'] ); ?>"
  			data-friction-y="<?php echo esc_attr( $atts['mouse_parallax_friction_y'] ); ?>"
  			data-origin-x="<?php echo esc_attr( $atts['mouse_parallax_origin_x'] ); ?>"
  			data-origin-y="<?php echo esc_attr( $atts['mouse_parallax_origin_y'] ); ?>">
  		<li class="layer layer-bg" data-depth="<?php echo esc_attr( $atts['mouse_parallax_depth'] ); ?>"><div></div></li>
  	</ul>
  	<?php endif; ?>

  	<?php if( $atts['section_effects'] == 'video' ): ?>
  		<?php
  			$_video_params = array(
  				'videoURL' => esc_attr( $atts['section_effect_video_url'] ),
  				'containment' => '#' . $shortcode_id . '-video',
  				'autoPlay' => 'true',
  				'mute' => esc_attr( $atts['section_effect_video_mute'] ),
  				'showControls' => 'false',
  				'quality' => 'hd720',
  				'loop' => 'true',
  				'showYTLogo' => 'false'
  			);

  			if( is_numeric( $atts['section_effect_video_fallback_img'] ) ) {
  				$_video_params['mobileFallbackImage'] = wp_get_attachment_url( $atts['section_effect_video_fallback_img'] );
  			}

  		?>
  	<div id="<?php echo esc_attr( $shortcode_id ); ?>-video" class="video-bg" data-property='<?php echo json_encode( $_video_params ); ?>' <?php if( $video_parallax ): ?>data-stellar-ratio="<?php echo esc_attr( $atts['section_effect_video_parallax_speed'] ); ?>"<?php endif; ?>></div>
  	<?php endif; ?>

  	<?php if( $atts['overlay_effect'] <> '' ): ?>
  	<div class="section-overlay-effect"></div>
  	<?php endif; ?>

  	<?php if( $particles ): ?>
  	<div class="particles-section">
  		<div class="particles-element" id="particles-<?php echo esc_attr( $shortcode_id ); ?>"></div>
  	</div>
  	<?php endif; ?>

  	<?php if( $bg_layers ): ?>
  	<div class="bg-layer-1"></div>
  	<div class="bg-layer-2"></div>
  	<?php endif; ?>

    <?php if( $centered_content ): ?>
  	<div class="centered-content-wrapper">
  	<?php endif; ?>

  	<?php echo do_shortcode( $content ); ?>

    <?php if( $centered_content ): ?>
  	</div>
  	<?php endif; ?>

  </div>

<?php if( $display_outer ): ?>
</div>
<?php endif; ?>

<?php if( !empty( $atts['full_width'] ) ): ?><div class="vc_row-full-width vc_clearfix"></div><?php endif;
